/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxDialogues;
import com.zhenshiz.chatbox.data.ChatBoxTriggerCount;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataManager;
import org.jetbrains.annotations.NotNull;

public class ChatBoxDialoguesLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ChatBoxDialoguesLoader INSTANCE = new ChatBoxDialoguesLoader();
    public static final Map<ResourceLocation, String> dialoguesMap = new HashMap<ResourceLocation, String>();
    public static final Map<ResourceLocation, Set<String>> dialoguesGroupMap = new HashMap<ResourceLocation, Set<String>>();
    private static final Map<ResourceLocation, Map<String, Map<String, Criterion>>> dialoguesCriteriaMap = new HashMap<ResourceLocation, Map<String, Map<String, Criterion>>>();
    public static final Map<ResourceLocation, Integer> defaultMaxTriggerCount = new HashMap<ResourceLocation, Integer>();
    private static final LootDataManager lootDataManager = new LootDataManager();

    public ChatBoxDialoguesLoader() {
        super(GSON, "chatbox/dialogues");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        dialoguesMap.clear();
        resourceLocationJsonElementMap.forEach((resourceLocation, jsonElement) -> dialoguesMap.put((ResourceLocation)resourceLocation, jsonElement.toString()));
    }

    public static <T extends AbstractCriterionTriggerInstance> void triggerDialog(ServerPlayer player, Predicate<T> testTrigger) {
        for (Map.Entry<ResourceLocation, Map<String, Map<String, Criterion>>> entry : dialoguesCriteriaMap.entrySet()) {
            ResourceLocation rl = entry.getKey();
            Map<String, Map<String, Criterion>> groupWithCriteria = entry.getValue();
            for (Map.Entry<String, Map<String, Criterion>> entry1 : groupWithCriteria.entrySet()) {
                String group = entry1.getKey();
                Map<String, Criterion> criteria = entry1.getValue();
                for (Map.Entry<String, Criterion> entry2 : criteria.entrySet()) {
                    Criterion criterion = entry2.getValue();
                    CriterionTriggerInstance instance = criterion.m_11416_();
                    try {
                        ChatBoxTriggerCount counts;
                        int count;
                        AbstractCriterionTriggerInstance t = (AbstractCriterionTriggerInstance)instance;
                        if (!testTrigger.test(t) || (count = (counts = ChatBox.getTriggerCounts()).getPlayerMaxTriggerCount(player, rl)) == 0) continue;
                        counts.setPlayerMaxTriggerCount(player, rl, count - 1);
                        ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.OpenScreen(rl, group, 0));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
    }

    public static void setDialogues() {
        dialoguesMap.forEach((resourceLocation, str) -> {
            JsonElement jsonElement = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (jsonElement == null) {
                return;
            }
            JsonElement dialoguesElement = jsonElement.getAsJsonObject().get("dialogues");
            if (dialoguesElement != null) {
                ChatBoxDialogues chatBoxDialogues = (ChatBoxDialogues)GSON.fromJson(jsonElement, new TypeToken<ChatBoxDialogues>(){}.getType());
                dialoguesGroupMap.put((ResourceLocation)resourceLocation, chatBoxDialogues.dialogues.keySet());
                JsonElement maxTriggerCountElement = jsonElement.getAsJsonObject().get("maxTriggerCount");
                int maxTriggerCount = maxTriggerCountElement != null ? maxTriggerCountElement.getAsInt() : -1;
                defaultMaxTriggerCount.put((ResourceLocation)resourceLocation, maxTriggerCount);
                JsonElement criteriaElement = jsonElement.getAsJsonObject().get("criteria");
                if (criteriaElement != null) {
                    JsonObject criteriaObject = criteriaElement.getAsJsonObject();
                    String group = (String)dialoguesGroupMap.get(resourceLocation).stream().toList().get(0);
                    try {
                        Map criteria = Criterion.m_11426_((JsonObject)criteriaObject, (DeserializationContext)new DeserializationContext(resourceLocation, lootDataManager));
                        HashMap<String, Map> groupCriteriaMap = new HashMap<String, Map>();
                        groupCriteriaMap.put(group, criteria);
                        dialoguesCriteriaMap.put((ResourceLocation)resourceLocation, (Map<String, Map<String, Criterion>>)groupCriteriaMap);
                    }
                    catch (Exception var6x) {
                        ChatBox.LOGGER.error("Parsing error loading dialog {}: {}", resourceLocation, (Object)var6x.getMessage());
                    }
                }
            }
        });
    }
}

