/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.data;

import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ChatBoxTriggerCount
extends SavedData {
    private final Map<UUID, Map<ResourceLocation, Integer>> maxTriggerCounts = new HashMap<UUID, Map<ResourceLocation, Integer>>();
    private final ServerLevel world;

    public ChatBoxTriggerCount(ServerLevel world) {
        this.world = world;
    }

    public int getPlayerMaxTriggerCount(ServerPlayer player, ResourceLocation rl) {
        this.m_77762_();
        Map counts = this.maxTriggerCounts.computeIfAbsent(player.m_20148_(), k -> ChatBoxDialoguesLoader.defaultMaxTriggerCount);
        return counts.getOrDefault(rl, ChatBoxDialoguesLoader.defaultMaxTriggerCount.getOrDefault(rl, 0));
    }

    public void setPlayerMaxTriggerCount(ServerPlayer player, ResourceLocation rl, int count) {
        Map counts = this.maxTriggerCounts.computeIfAbsent(player.m_20148_(), k -> ChatBoxDialoguesLoader.defaultMaxTriggerCount);
        counts.put(rl, count);
        this.maxTriggerCounts.put(player.m_20148_(), counts);
        this.m_77762_();
    }

    public void resetPlayerMaxTriggerCount(ServerPlayer player) {
        this.maxTriggerCounts.remove(player.m_20148_());
        this.m_77762_();
    }

    public static ChatBoxTriggerCount fromNbt(ServerLevel world, CompoundTag nbt) {
        ChatBoxTriggerCount count = new ChatBoxTriggerCount(world);
        for (String player : nbt.m_128431_()) {
            UUID uuid = UUID.fromString(player);
            HashMap<ResourceLocation, Integer> counts = new HashMap<ResourceLocation, Integer>();
            ListTag listTag = nbt.m_128437_(player, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                ResourceLocation rl = ResourceLocation.m_135820_((String)compoundTag.m_128461_("Dialogue"));
                int num = compoundTag.m_128451_("MaxTriggerCount");
                counts.put(rl, num);
            }
            count.maxTriggerCounts.put(uuid, counts);
        }
        return count;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        for (Map.Entry<UUID, Map<ResourceLocation, Integer>> entry : this.maxTriggerCounts.entrySet()) {
            ListTag listTag = new ListTag();
            UUID player = entry.getKey();
            Map<ResourceLocation, Integer> playerCounts = entry.getValue();
            for (Map.Entry<ResourceLocation, Integer> entry1 : playerCounts.entrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128359_("Dialogue", entry1.getKey().toString());
                compoundTag.m_128405_("MaxTriggerCount", entry1.getValue().intValue());
                listTag.add((Object)compoundTag);
            }
            nbt.m_128365_(player.toString(), (Tag)listTag);
        }
        return nbt;
    }
}

