/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.event;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.data.ChatBoxDialoguesLoader;
import com.zhenshiz.chatbox.data.ChatBoxThemeLoader;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chatbox")
public class ChatBoxSettingLoader {
    private static final int STRING_SIZE_LIMIT = 32000;

    @SubscribeEvent
    public static void chatBoxLoader(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ChatBoxThemeLoader.INSTANCE);
        event.addListener((PreparableReloadListener)ChatBoxDialoguesLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void initializeChatBoxScreen(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            ChatBoxSettingLoader.initializeChatBoxScreen(player);
        } else {
            event.getPlayerList().m_11314_().forEach(ChatBoxSettingLoader::initializeChatBoxScreen);
        }
    }

    private static void initializeChatBoxScreen(ServerPlayer player) {
        ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.AllChatBoxThemeToClient(ChatBoxSettingLoader.cutString(ChatBoxThemeLoader.themeMap)));
        ChatBox.PLATFORM.sendToClient(player, new ChatBoxPayload.AllChatBoxDialoguesToClient(ChatBoxSettingLoader.cutString(ChatBoxDialoguesLoader.dialoguesMap)));
    }

    private static Map<ResourceLocation, List<String>> cutString(Map<ResourceLocation, String> map) {
        HashMap<ResourceLocation, List<String>> result = new HashMap<ResourceLocation, List<String>>();
        for (Map.Entry<ResourceLocation, String> entry : map.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String data = entry.getValue();
            ArrayList<String> parts = new ArrayList<String>();
            for (int i = 0; i < data.length(); i += 32000) {
                parts.add(data.substring(i, Math.min(i + 32000, data.length())));
            }
            result.put(rl, parts);
        }
        return result;
    }
}

