/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.network;

import com.zhenshiz.chatbox.network.CustomPacket;
import com.zhenshiz.chatbox.network.c2s.SendCommandPayload;
import com.zhenshiz.chatbox.network.s2c.ChatBoxPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkForge {
    private static final Supplier<String> VERSION = () -> "chatbox";
    private static final Predicate<String> ACCEPT = version -> version.equals(VERSION.get());
    private static final Map<Class<? extends CustomPacket>, SimpleChannel> CHANNELS = new HashMap<Class<? extends CustomPacket>, SimpleChannel>();
    public static final SimpleChannel OPEN_SCREEN = NetworkForge.registerChannel(ChatBoxPayload.OpenScreen.class);
    public static final SimpleChannel OPEN_CHATBOX = NetworkForge.registerChannel(ChatBoxPayload.OpenChatBox.class);
    public static final SimpleChannel TOGGLE_THEME = NetworkForge.registerChannel(ChatBoxPayload.ToggleTheme.class);
    public static final SimpleChannel ALL_CHATBOX_THEME_TO_CLIENT = NetworkForge.registerChannel(ChatBoxPayload.AllChatBoxThemeToClient.class);
    public static final SimpleChannel ALL_CHATBOX_DIALOGUES_TO_CLIENT = NetworkForge.registerChannel(ChatBoxPayload.AllChatBoxDialoguesToClient.class);
    public static final SimpleChannel NEXT_DIALOGUE = NetworkForge.registerChannel(ChatBoxPayload.NextDialogue.class);
    public static final SimpleChannel AUTO_PLAY = NetworkForge.registerChannel(ChatBoxPayload.AutoPlay.class);
    public static final SimpleChannel SEND_COMMAND = NetworkForge.registerChannel(SendCommandPayload.class);
    private static int id = 0;

    private static SimpleChannel registerChannel(Class<? extends CustomPacket> packet) {
        try {
            SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)((ResourceLocation)packet.getField("ID").get(null)), VERSION, ACCEPT, ACCEPT);
            CHANNELS.put(packet, channel);
            return channel;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static int nextId() {
        return ++id;
    }

    public static void registerHandlers() {
        OPEN_SCREEN.registerMessage(NetworkForge.nextId(), ChatBoxPayload.OpenScreen.class, ChatBoxPayload.OpenScreen::encode, ChatBoxPayload.OpenScreen::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ChatBoxPayload.OpenScreen.handleOnClient(packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        OPEN_CHATBOX.registerMessage(NetworkForge.nextId(), ChatBoxPayload.OpenChatBox.class, ChatBoxPayload.OpenChatBox::encode, ChatBoxPayload.OpenChatBox::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ChatBoxPayload.OpenChatBox.handleOnClient(packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        TOGGLE_THEME.registerMessage(NetworkForge.nextId(), ChatBoxPayload.ToggleTheme.class, ChatBoxPayload.ToggleTheme::encode, ChatBoxPayload.ToggleTheme::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ChatBoxPayload.ToggleTheme.handleOnClient(packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        ALL_CHATBOX_THEME_TO_CLIENT.registerMessage(NetworkForge.nextId(), ChatBoxPayload.AllChatBoxThemeToClient.class, ChatBoxPayload.AllChatBoxThemeToClient::encode, ChatBoxPayload.AllChatBoxThemeToClient::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ChatBoxPayload.AllChatBoxThemeToClient.handleOnClient(packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        ALL_CHATBOX_DIALOGUES_TO_CLIENT.registerMessage(NetworkForge.nextId(), ChatBoxPayload.AllChatBoxDialoguesToClient.class, ChatBoxPayload.AllChatBoxDialoguesToClient::encode, ChatBoxPayload.AllChatBoxDialoguesToClient::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ChatBoxPayload.AllChatBoxDialoguesToClient.handleOnClient(packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        NEXT_DIALOGUE.registerMessage(NetworkForge.nextId(), ChatBoxPayload.NextDialogue.class, ChatBoxPayload.NextDialogue::encode, ChatBoxPayload.NextDialogue::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ChatBoxPayload.NextDialogue.handleOnClient(packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        AUTO_PLAY.registerMessage(NetworkForge.nextId(), ChatBoxPayload.AutoPlay.class, ChatBoxPayload.AutoPlay::encode, ChatBoxPayload.AutoPlay::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ChatBoxPayload.AutoPlay.handleOnClient(packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        SEND_COMMAND.registerMessage(NetworkForge.nextId(), SendCommandPayload.class, SendCommandPayload::encode, SendCommandPayload::decode, (packet, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> NetworkForge.lambda$registerHandlers$16((Supplier)ctx, packet));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static SimpleChannel getChannel(CustomPacket packet) {
        return CHANNELS.get(packet.getClass());
    }

    private static /* synthetic */ void lambda$registerHandlers$16(Supplier ctx, SendCommandPayload packet) {
        ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
        if (sender != null) {
            MinecraftServer server = sender.m_20194_();
            SendCommandPayload.handleOnServer(server, sender, packet);
        }
    }
}

