/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.render;

import com.zhenshiz.chatbox.ChatBox;
import com.zhenshiz.chatbox.client.ChatBoxClient;
import com.zhenshiz.chatbox.component.AbstractComponent;
import com.zhenshiz.chatbox.component.ChatOption;
import com.zhenshiz.chatbox.utils.chatbox.ChatBoxUtil;
import com.zhenshiz.chatbox.utils.chatbox.RenderUtil;
import com.zhenshiz.chatbox.utils.common.CollUtil;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class ChatBoxRenderCommon {
    public static Boolean isOpenChatBox = false;
    public static int selectIndex = 0;
    private static final Minecraft minecraft = Minecraft.m_91087_();

    public static void onHudRender(GuiGraphics guiGraphics, float partialTick) {
        if (ChatBoxRenderCommon.isRenderChatBox()) {
            if (ChatBox.PLATFORM.postRenderEventPre(guiGraphics)) {
                return;
            }
            if (ChatBoxUtil.chatBoxScreen.backgroundImage != null) {
                RenderUtil.renderImage(guiGraphics, ChatBoxUtil.chatBoxScreen.backgroundImage, 0.0f, 0.0f, 0.0f, RenderUtil.screenWidth(), RenderUtil.screenHeight(), 1.0f);
            }
            ArrayList<AbstractComponent> list = new ArrayList<AbstractComponent>();
            list.add(ChatBoxUtil.chatBoxScreen.dialogBox);
            if (ChatBoxUtil.chatBoxScreen.video != null) {
                list.add(ChatBoxUtil.chatBoxScreen.video);
            }
            if (ChatBoxUtil.chatBoxScreen.chatOptions != null) {
                list.addAll(ChatBoxUtil.chatBoxScreen.chatOptions);
            }
            if (ChatBoxUtil.chatBoxScreen.portraits != null) {
                list.addAll(ChatBoxUtil.chatBoxScreen.portraits);
            }
            if (ChatBoxUtil.chatBoxScreen.keyPromptRender != null) {
                list.add(ChatBoxUtil.chatBoxScreen.keyPromptRender);
            }
            list.sort(Comparator.comparingInt(p -> p.renderOrder));
            list.forEach(abstractComponent -> abstractComponent.render(guiGraphics, partialTick));
            ChatBox.PLATFORM.postRenderEventPost(guiGraphics);
        }
    }

    public static void onEndTick(Minecraft minecraft) {
        if (ChatBoxRenderCommon.isRenderChatBox()) {
            ChatBoxUtil.chatBoxScreen.m_86600_();
        }
    }

    public static void onKey(int key, int scancode, int action, int modifiers) {
        if (ChatBoxRenderCommon.isRenderChatBox() && ChatBoxUtil.chatBoxScreen.keyPromptRender.visible.booleanValue()) {
            if (key == 341) {
                ChatBoxUtil.chatBoxScreen.dialogBox.click(ChatBoxUtil.chatBoxScreen.shouldGotoNext());
            }
            if (action == 1 && key == 295) {
                ChatBoxUtil.chatBoxScreen.autoPlay = !ChatBoxUtil.chatBoxScreen.autoPlay;
            }
        }
    }

    public static void mousePost(int button, int action, int modifiers) {
        if (ChatBoxRenderCommon.isRenderChatBox() && action == 1 && button == 1) {
            if (!CollUtil.isEmpty(ChatBoxUtil.chatBoxScreen.chatOptions).booleanValue() && ChatBoxUtil.chatBoxScreen.dialogBox.isAllOver) {
                ChatOption chatOption = ChatBoxUtil.chatBoxScreen.chatOptions.get(selectIndex);
                chatOption.click();
                selectIndex = 0;
            }
            if (ChatBoxUtil.chatBoxScreen.keyPromptRender.visible.booleanValue()) {
                ChatBoxUtil.chatBoxScreen.dialogBox.click(ChatBoxUtil.chatBoxScreen.shouldGotoNext());
            }
        }
    }

    public static boolean onMouseScroll(double scrollDelta, boolean leftDown, boolean middleDown, boolean rightDown, double mouseX, double mouseY) {
        if (ChatBoxRenderCommon.isRenderChatBox() && !ChatBoxUtil.chatBoxScreen.chatOptions.isEmpty()) {
            if (scrollDelta > 0.0) {
                selectIndex = (selectIndex - 1 + ChatBoxUtil.chatBoxScreen.chatOptions.size()) % ChatBoxUtil.chatBoxScreen.chatOptions.size();
            } else if (scrollDelta < 0.0) {
                selectIndex = (selectIndex + 1) % ChatBoxUtil.chatBoxScreen.chatOptions.size();
            }
            for (int i = 0; i < ChatBoxUtil.chatBoxScreen.chatOptions.size(); ++i) {
                ChatOption chatOption = ChatBoxUtil.chatBoxScreen.chatOptions.get(i);
                chatOption.isSelect = i == selectIndex;
            }
            return true;
        }
        return false;
    }

    private static boolean isRenderChatBox() {
        return !ChatBoxClient.conf.isScreen && isOpenChatBox != false && ChatBoxRenderCommon.minecraft.f_91080_ == null && ChatBoxUtil.chatBoxScreen.dialogBox != null;
    }

    public static void onClose() {
        isOpenChatBox = false;
        ChatBoxUtil.chatBoxScreen.autoPlay = false;
        ChatBoxUtil.chatBoxScreen.fastForward = false;
        if (ChatBoxUtil.chatBoxScreen.video != null) {
            ChatBoxUtil.chatBoxScreen.video.close();
        }
    }
}

