/*
 * Decompiled with CFR 0.152.
 */
package com.zhenshiz.chatbox.utils.chatbox;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

public class RenderUtil {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Map<String, ResourceLocation> skins = new HashMap<String, ResourceLocation>();

    public static int screenWidth() {
        return minecraft.m_91268_().m_85445_();
    }

    public static int screenHeight() {
        return minecraft.m_91268_().m_85446_();
    }

    public static void fillRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int color) {
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        buf.m_252986_(mat, (float)x, (float)y, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)(x + w), (float)y, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)(x + w), (float)(y + h), 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)x, (float)(y + h), 0.0f).m_193479_(color).m_5752_();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillArc(GuiGraphics guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        buf.m_252986_(mat, (float)cX, (float)cY, 0.0f).m_193479_(color).m_5752_();
        for (int i = start - 90; i <= end - 90; ++i) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            buf.m_252986_(mat, x, y, 0.0f).m_193479_(color).m_5752_();
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillCircle(GuiGraphics guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.fillArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void fillAnnulusArc(GuiGraphics guiGraphics, int cx, int cy, int radius, int start, int end, int thickness, int color) {
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        for (int i = start - 90; i <= end - 90; ++i) {
            float angle = (float)Math.toRadians(i);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float x1 = (float)cx + cos * (float)radius;
            float y1 = (float)cy + sin * (float)radius;
            float x2 = (float)cx + cos * (float)(radius + thickness);
            float y2 = (float)cy + sin * (float)(radius + thickness);
            buf.m_252986_(mat, x1, y1, 0.0f).m_193479_(color).m_5752_();
            buf.m_252986_(mat, x2, y2, 0.0f).m_193479_(color).m_5752_();
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillAnnulus(GuiGraphics guiGraphics, int cx, int cy, int radius, int thickness, int color) {
        RenderUtil.fillAnnulusArc(guiGraphics, cx, cy, radius, 0, 360, thickness, color);
    }

    public static void fillRoundRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.m_14045_((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        buf.m_252986_(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).m_193479_(color).m_5752_();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.m_252986_(mat, rx, ry, 0.0f).m_193479_(color).m_5752_();
            }
        }
        buf.m_252986_(mat, (float)corners[0][0], (float)y, 0.0f).m_193479_(color).m_5752_();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundShadow(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int thickness, int innerColor, int outerColor) {
        r = Mth.m_14045_((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx1 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry1 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                float rx2 = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)(r + thickness));
                float ry2 = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)(r + thickness));
                buf.m_252986_(mat, rx1, ry1, 0.0f).m_193479_(innerColor).m_5752_();
                buf.m_252986_(mat, rx2, ry2, 0.0f).m_193479_(outerColor).m_5752_();
            }
        }
        buf.m_252986_(mat, (float)corners[0][0], (float)y, 0.0f).m_193479_(innerColor).m_5752_();
        buf.m_252986_(mat, (float)corners[0][0], (float)(y - thickness), 0.0f).m_193479_(outerColor).m_5752_();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundTabTop(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.m_14045_((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        buf.m_252986_(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).m_193479_(color).m_5752_();
        int[][] corners = new int[][]{{x + r, y + r}, {x + w - r, y + r}};
        for (int corner = 0; corner < 2; ++corner) {
            int cornerStart = (corner - 2) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.m_252986_(mat, rx, ry, 0.0f).m_193479_(color).m_5752_();
            }
        }
        buf.m_252986_(mat, (float)(x + w), (float)(y + h), 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)x, (float)(y + h), 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)x, (float)corners[0][1], 0.0f).m_193479_(color).m_5752_();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundTabBottom(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.m_14045_((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        buf.m_252986_(mat, (float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 0.0f).m_193479_(color).m_5752_();
        int[][] corners = new int[][]{{x + w - r, y + h - r}, {x + r, y + h - r}};
        for (int corner = 0; corner < 2; ++corner) {
            int cornerStart = corner * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.m_252986_(mat, rx, ry, 0.0f).m_193479_(color).m_5752_();
            }
        }
        buf.m_252986_(mat, (float)x, (float)y, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)(x + w), (float)y, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)(x + w), (float)corners[0][1], 0.0f).m_193479_(color).m_5752_();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void fillRoundHorLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void fillRoundVerLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.fillRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void drawRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawHorLine(guiGraphics, x, y, w, color);
        RenderUtil.drawVerLine(guiGraphics, x, y + 1, h - 2, color);
        RenderUtil.drawVerLine(guiGraphics, x + w - 1, y + 1, h - 2, color);
        RenderUtil.drawHorLine(guiGraphics, x, y + h - 1, w, color);
    }

    public static void drawBox(GuiGraphics guiGraphics, int x, int y, int w, int h, int color) {
        RenderUtil.drawLine(guiGraphics, x, y, x + w, y, color);
        RenderUtil.drawLine(guiGraphics, x, y + h, x + w, y + h, color);
        RenderUtil.drawLine(guiGraphics, x, y, x, y + h, color);
        RenderUtil.drawLine(guiGraphics, x + w, y, x + w, y + h, color);
    }

    public static void drawHorLine(GuiGraphics guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, length, 1, color);
    }

    public static void drawVerLine(GuiGraphics guiGraphics, int x, int y, int length, int color) {
        RenderUtil.fillRect(guiGraphics, x, y, 1, length, color);
    }

    public static void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color) {
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        buf.m_252986_(mat, (float)x1, (float)y1, 0.0f).m_193479_(color).m_5752_();
        buf.m_252986_(mat, (float)x2, (float)y2, 0.0f).m_193479_(color).m_5752_();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawArc(GuiGraphics guiGraphics, int cX, int cY, int radius, int start, int end, int color) {
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        for (int i = start - 90; i <= end - 90; ++i) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            buf.m_252986_(mat, x, y, 0.0f).m_193479_(color).m_5752_();
        }
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawCircle(GuiGraphics guiGraphics, int cX, int cY, int radius, int color) {
        RenderUtil.drawArc(guiGraphics, cX, cY, radius, 0, 360, color);
    }

    public static void drawRoundRect(GuiGraphics guiGraphics, int x, int y, int w, int h, int r, int color) {
        r = Mth.m_14045_((int)r, (int)0, (int)(Math.min(w, h) / 2));
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        int[][] corners = new int[][]{{x + w - r, y + r}, {x + w - r, y + h - r}, {x + r, y + h - r}, {x + r, y + r}};
        for (int corner = 0; corner < 4; ++corner) {
            int cornerStart = (corner - 1) * 90;
            int cornerEnd = cornerStart + 90;
            for (int i = cornerStart; i <= cornerEnd; i += 10) {
                float angle = (float)Math.toRadians(i);
                float rx = (float)corners[corner][0] + (float)(Math.cos(angle) * (double)r);
                float ry = (float)corners[corner][1] + (float)(Math.sin(angle) * (double)r);
                buf.m_252986_(mat, rx, ry, 0.0f).m_193479_(color).m_5752_();
            }
        }
        buf.m_252986_(mat, (float)corners[0][0], (float)y, 0.0f).m_193479_(color).m_5752_();
        RenderUtil.beginRendering();
        RenderUtil.drawBuffer(buf);
        RenderUtil.finishRendering();
    }

    public static void drawRoundHorLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, length, thickness, thickness / 2, color);
    }

    public static void drawRoundVerLine(GuiGraphics guiGraphics, int x, int y, int length, int thickness, int color) {
        RenderUtil.drawRoundRect(guiGraphics, x, y, thickness, length, thickness / 2, color);
    }

    public static void renderImage(GuiGraphics guiGraphics, ResourceLocation resourceLocation, float x, float y, float z, float uw, float uh, float width, float height) {
        BufferBuilder buf = RenderUtil.getBuffer();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        buf.m_252986_(matrix4f, x, y, z).m_7421_(0.0f, 0.0f).m_5752_();
        buf.m_252986_(matrix4f, x, y + height, z).m_7421_(0.0f, uh).m_5752_();
        buf.m_252986_(matrix4f, x + width, y + height, z).m_7421_(uw, uh).m_5752_();
        buf.m_252986_(matrix4f, x + width, y, z).m_7421_(uw, 0.0f).m_5752_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.enableBlend();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void renderImage(GuiGraphics guiGraphics, ResourceLocation resourceLocation, float x, float y, float z, float width, float height, float scale) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        RenderUtil.renderImage(guiGraphics, resourceLocation, x /= scale, y /= scale, z, 1.0f, 1.0f, width, height);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderPlayerHead(GuiGraphics guiGraphics, String input, int x, int y, int size, float scale) {
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)RenderUtil.getSkin(input), (int)x, (int)y, (int)size);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderItem(GuiGraphics guiGraphics, ItemStack item, int x, int y, float scale, String text) {
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280480_(item, x, y);
        guiGraphics.m_280302_(RenderUtil.minecraft.f_91062_, item, x, y, text);
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderItem(GuiGraphics guiGraphics, ItemStack item, int x, int y, float scale) {
        RenderUtil.renderItem(guiGraphics, item, x, y, scale, "");
    }

    public static void drawLeftScaleText(GuiGraphics guiGraphics, Component component, int x, int y, float scale, boolean shadow, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85841_(scale, scale, scale);
        float rescale = 1.0f / scale;
        x = (int)((float)x * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.m_280614_(RenderUtil.minecraft.f_91062_, component, x, y, color, shadow);
        poseStack.m_85841_(rescale, rescale, rescale);
    }

    public static void drawCenterScaleText(GuiGraphics guiGraphics, Component component, int centerX, int y, float scale, boolean shadow, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85841_(scale, scale, scale);
        float rescale = 1.0f / scale;
        centerX = (int)((float)centerX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.m_280614_(RenderUtil.minecraft.f_91062_, component, centerX -= RenderUtil.minecraft.f_91062_.m_92852_((FormattedText)component) / 2, y, color, shadow);
        poseStack.m_85841_(rescale, rescale, rescale);
    }

    public static void drawRightScaleText(GuiGraphics guiGraphics, Component component, int rightX, int y, float scale, boolean shadow, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85841_(scale, scale, scale);
        float rescale = 1.0f / scale;
        rightX = (int)((float)rightX * rescale);
        y = (int)((float)y * rescale);
        guiGraphics.m_280614_(RenderUtil.minecraft.f_91062_, component, rightX -= RenderUtil.minecraft.f_91062_.m_92852_((FormattedText)component), y, color, shadow);
        poseStack.m_85841_(rescale, rescale, rescale);
    }

    public static void setCursor(int x, int y) {
        Window window = minecraft.m_91268_();
        int w1 = window.m_85441_();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.m_85442_();
        int h2 = RenderUtil.screenHeight();
        double ratW = (double)w2 / (double)w1;
        double ratH = (double)h2 / (double)h1;
        GLFW.glfwSetCursorPos((long)window.m_85439_(), (double)((double)x / ratW), (double)((double)y / ratH));
    }

    public static Point getCursor() {
        Window window = minecraft.m_91268_();
        int w1 = window.m_85441_();
        int w2 = RenderUtil.screenWidth();
        int h1 = window.m_85442_();
        int h2 = RenderUtil.screenHeight();
        double rW = (double)w2 / (double)w1;
        double rH = (double)h2 / (double)h1;
        return new Point((int)(rW * RenderUtil.minecraft.f_91067_.m_91589_()), (int)(rH * RenderUtil.minecraft.f_91067_.m_91594_()));
    }

    public static void renderOpacity(GuiGraphics guiGraphics, float opacity, Runnable runnable) {
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, opacity);
        runnable.run();
        RenderSystem.disableBlend();
    }

    private static void drawBuffer(BufferBuilder buf) {
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
    }

    public static void beginRendering() {
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
    }

    public static void finishRendering() {
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
    }

    private static BufferBuilder getBuffer() {
        return Tesselator.m_85913_().m_85915_();
    }

    private static GameProfile createProfileComponent(String input) {
        try {
            return new GameProfile(UUID.fromString(input), null);
        }
        catch (IllegalArgumentException e) {
            return new GameProfile(null, input);
        }
    }

    private static ResourceLocation getSkin(String input) {
        if (skins.containsKey(input)) {
            return skins.get(input);
        }
        GameProfile profile = RenderUtil.createProfileComponent(input);
        SkullBlockEntity.m_155738_((GameProfile)profile, gameProfile -> {
            SkinManager manager = minecraft.m_91109_();
            Map map = manager.m_118815_(gameProfile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                skins.put(input, manager.m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
            }
        });
        if (skins.containsKey(input)) {
            return skins.get(input);
        }
        return DefaultPlayerSkin.m_118627_((UUID)Objects.requireNonNull(minecraft.m_91094_().m_240411_()));
    }
}

