/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldAttackSelector
implements Predicate<LivingEntity> {
    private final AbstractKoboldEntity kobold;

    public KoboldAttackSelector(AbstractKoboldEntity source) {
        this.kobold = source;
    }

    @Override
    public boolean test(@Nullable LivingEntity target) {
        LivingEntity dragon;
        ServerLevel lvl;
        Entity entity;
        Level level;
        if (this.kobold.getDragonReference() != null && (level = this.kobold.level()) instanceof ServerLevel && (entity = (lvl = (ServerLevel)level).getEntity(this.kobold.getDragonReference())) instanceof LivingEntity && this.kobold.distanceTo((Entity)(dragon = (LivingEntity)entity)) <= 32.0f) {
            if (dragon.getLastHurtByMob() != null && dragon.getLastHurtByMob().isAlive() && this.kobold.hasLineOfSight((Entity)dragon.getLastHurtByMob())) {
                return target.is((Entity)dragon.getLastHurtByMob());
            }
            if (dragon.getLastHurtMob() != null && dragon.getLastHurtMob().isAlive() && this.kobold.hasLineOfSight((Entity)dragon.getLastHurtMob())) {
                return target.is((Entity)dragon.getLastHurtMob());
            }
        }
        if (this.kobold instanceof KoboldWarrior) {
            return target.getType().is(KoboldsTags.TARGETZ);
        }
        return target.getType().is(KoboldsTags.TARGETS);
    }
}

