/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.client.renderer.layers.KoboldItemInHandLayer;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldSkeleton;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.init.KoboldsClient;

public abstract class AbstractKoboldRenderer
extends MobRenderer<Mob, AbstractKoboldState, KoboldModel<AbstractKoboldState>> {
    public AbstractKoboldRenderer(EntityRendererProvider.Context context, KoboldModel<AbstractKoboldState> model, boolean check) {
        super(context, model, 0.36f);
        if (check) {
            this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, ArmorModelSet.bake(KoboldsClient.KOBOLD_ARMOR, (EntityModelSet)context.getModelSet(), KoboldModel::new), ArmorModelSet.bake(KoboldsClient.KOBOLD_ARMOR, (EntityModelSet)context.getModelSet(), KoboldModel::new), context.getEquipmentRenderer()));
            this.addLayer((RenderLayer)new KoboldItemInHandLayer(this));
        }
    }

    public ResourceLocation getTextureLocation(AbstractKoboldState kobold) {
        return kobold.texture;
    }

    public AbstractKoboldState createRenderState() {
        return new AbstractKoboldState();
    }

    public void extractRenderState(Mob target, AbstractKoboldState state, float f1) {
        super.extractRenderState((LivingEntity)target, (LivingEntityRenderState)state, f1);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)target, (HumanoidRenderState)state, (float)f1, (ItemModelResolver)this.itemModelResolver);
        if (target instanceof AbstractKoboldEntity) {
            AbstractKoboldEntity kobold = (AbstractKoboldEntity)target;
            state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/" + this.getKoboldType(kobold) + ".png"));
            state.isCharging = kobold.isCharging();
            state.isDiamond = kobold.isDiamond();
            state.dragonColor = kobold.getDragonColor();
        } else {
            state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/" + this.getKoboldType(null) + ".png"));
            if (target instanceof KoboldSkeleton) {
                KoboldSkeleton kobold = (KoboldSkeleton)target;
                state.isCharging = kobold.isCharging();
            } else if (target instanceof KoboldZombie) {
                KoboldZombie kobold = (KoboldZombie)target;
                state.texture = kobold.getName().getString().equals("James") && kobold.getZomboType().equals("enchanter") ? ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/undead/zombie_james.png") : ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/undead/zombie_" + kobold.getZomboType() + ".png"));
                state.getZomboType = kobold.getZomboType();
                state.isZomboConverting = kobold.isConvert();
            }
        }
        state.isAggressive = target.isAggressive();
        state.isBlocking = target.isBlocking();
        state.isLeftHanded = target.isLeftHanded();
        state.rightStack = target.getItemHeldByArm(HumanoidArm.RIGHT);
        state.leftStack = target.getItemHeldByArm(HumanoidArm.LEFT);
    }

    public void submit(AbstractKoboldState kobold, PoseStack pose, SubmitNodeCollector buffer, CameraRenderState c) {
        pose.pushPose();
        pose.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        pose.scale(scale, scale, scale);
        super.submit((LivingEntityRenderState)kobold, pose, buffer, c);
        pose.popPose();
    }

    public abstract String getKoboldType(@Nullable AbstractKoboldEntity var1);
}

