/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.salju.kobolds.client.model.KoboldChildModel;
import net.salju.kobolds.client.renderer.AbstractKoboldRenderer;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.client.renderer.layers.KoboldEyesLayer;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldChildRenderer
extends AbstractKoboldRenderer {
    public KoboldChildRenderer(EntityRendererProvider.Context context) {
        super(context, new KoboldChildModel<AbstractKoboldState>(context.bakeLayer(KoboldsClient.KOBOLD_CHILD)), false);
        this.addLayer((RenderLayer)new KoboldEyesLayer(this));
    }

    @Override
    public void submit(AbstractKoboldState kobold, PoseStack pose, SubmitNodeCollector buffer, CameraRenderState c) {
        pose.pushPose();
        pose.translate(-0.025, 0.0, 0.0);
        float scale = 0.45f;
        pose.scale(scale, scale, scale);
        super.submit(kobold, pose, buffer, c);
        pose.popPose();
    }

    @Override
    public String getKoboldType(AbstractKoboldEntity kobold) {
        if (kobold.getDragonColor() >= 1) {
            return "special/dragon/child/" + kobold.getDragonColor();
        }
        return "kobolds/child";
    }
}

