/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldPotionGoal
extends Goal {
    public final AbstractKoboldEntity kobold;

    public KoboldPotionGoal(AbstractKoboldEntity kobold) {
        this.kobold = kobold;
    }

    public boolean canUse() {
        return this.isHoldingPotion();
    }

    public boolean canContinueToUse() {
        if (!this.kobold.isUsingItem() && this.isHoldingPotion()) {
            InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.kobold, item -> new ItemStack((ItemLike)item).is(Items.POTION) || new ItemStack((ItemLike)item).is(Items.GLASS_BOTTLE));
            if (this.kobold.hasEffect(MobEffects.SLOWNESS)) {
                this.kobold.removeEffect(MobEffects.SLOWNESS);
            }
            this.kobold.setItemInHand(hand, ItemStack.EMPTY);
        }
        return super.canContinueToUse();
    }

    public void start() {
        InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.kobold, item -> new ItemStack((ItemLike)item).is(Items.POTION));
        this.kobold.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, this.kobold.getItemInHand(hand).getUseDuration((LivingEntity)this.kobold), 10, false, false));
        this.kobold.startUsingItem(hand);
    }

    private boolean isHoldingPotion() {
        return this.kobold.isHolding(stack -> stack.is(Items.POTION)) || this.kobold.isHolding(stack -> stack.is(Items.GLASS_BOTTLE));
    }
}

