/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.events;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldRascal;
import net.salju.kobolds.events.KoboldEvent;
import net.salju.kobolds.events.KoboldsManager;

@EventBusSubscriber
public class KoboldsEvents {
    @SubscribeEvent
    public static void onEntitySpawned(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Raider) {
            Raider johnny = (Raider)entity;
            johnny.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)johnny, AbstractKoboldEntity.class, false));
        } else {
            Zombie billy;
            entity = event.getEntity();
            if (entity instanceof Zombie && !((billy = (Zombie)entity) instanceof ZombifiedPiglin)) {
                billy.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)billy, AbstractKoboldEntity.class, false));
            }
        }
    }

    @SubscribeEvent
    public static void onDragon(KoboldEvent.DragonEvent event) {
    }

    @SubscribeEvent
    public static void onAttackTarget(LivingChangeTargetEvent event) {
        if (event.getEntity() instanceof Zombie && event.getOriginalAboutToBeSetTarget() instanceof KoboldRascal && event.getEntity().getLastHurtByMob() != event.getOriginalAboutToBeSetTarget()) {
            event.setCanceled(true);
        } else if (event.getEntity() instanceof AbstractKoboldEntity && event.getOriginalAboutToBeSetTarget() instanceof AbstractKoboldEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity src;
        int e;
        Entity entity;
        if (event.getSource().getEntity() != null && event.getEntity() instanceof Enemy && (entity = event.getSource().getEntity()) instanceof LivingEntity && (e = (src = (LivingEntity)entity).getMainHandItem().getEnchantmentLevel(KoboldsManager.getEnchantment(src.level().registryAccess(), "kobolds", "prospector"))) > 0) {
            double check;
            double d = check = src.hasEffect(MobEffects.LUCK) ? 0.25 : 0.05;
            if (!event.getEntity().isAlive() && !event.getEntity().level().isClientSide() && Math.random() <= check) {
                for (int i = 0; i < e; ++i) {
                    event.getEntity().level().addFreshEntity((Entity)new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)Items.EMERALD)));
                }
            }
        }
    }
}

