/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class RascalModel<T extends AbstractKoboldEntity>
extends KoboldModel<T> {
    public final ModelPart bag;

    public RascalModel(ModelPart root) {
        super(root);
        this.bag = root.getChild("bag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = KoboldModel.createMesh(new CubeDeformation(0.0f), 0.0f);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("bag", CubeListBuilder.create().texOffs(26, 30).addBox(-1.0f, 0.0f, 2.0f, 5.0f, 7.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(33, 7).addBox(-5.0f, -0.85f, -1.5f, 8.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public void setupAnim(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.xRot = -0.7854f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.body.xRot = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.rightArm.zRot += Mth.cos((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.leftArm.zRot -= Mth.cos((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (kobold.isPassenger()) {
            this.rightLeg.xRot = -1.5708f;
            this.leftLeg.xRot = -1.5708f;
            this.rightLeg.yRot = 0.2618f;
            this.leftLeg.yRot = -0.2618f;
        }
        if (!kobold.getMainHandItem().isEmpty() && kobold.isAggressive()) {
            this.rightArm.xRot = -2.0944f;
            this.rightArm.yRot = 0.1745f;
        }
        if (this.attackTime > 0.0f) {
            if (kobold.isAggressive()) {
                float progress = this.attackTime;
                progress = 1.0f - this.attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 / 1.2 - 1.0));
            } else {
                float progress = this.attackTime;
                this.body.yRot = Mth.sin((float)(Mth.sqrt((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                this.rightArm.yRot += this.body.yRot;
                this.leftArm.yRot += this.body.yRot;
                this.leftArm.xRot += this.body.yRot;
                progress = 1.0f - this.attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                float f3 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
                this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 * 1.2 + (double)f3));
                this.rightArm.yRot += this.body.yRot * 2.0f;
                this.rightArm.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
            }
        }
        this.hat.copyFrom(this.head);
    }

    public void renderToBuffer(PoseStack pose, VertexConsumer buffer, int light, int overlay, int color) {
        super.renderToBuffer(pose, buffer, light, overlay, color);
        this.bag.render(pose, buffer, light, overlay, color);
    }

    @Override
    public void translateToHand(HumanoidArm arm, PoseStack pose) {
        switch (arm) {
            case LEFT: 
            case RIGHT: {
                this.rightArm.translateAndRotate(pose);
                pose.translate(-0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
            }
        }
    }
}

