/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.KoboldArmorModel;
import net.salju.kobolds.client.model.ZomboldModel;
import net.salju.kobolds.client.renderer.layers.KoboldZombieEyesLayer;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldZombieRenderer
extends MobRenderer<KoboldZombie, ZomboldModel<KoboldZombie>> {
    public KoboldZombieRenderer(EntityRendererProvider.Context context) {
        super(context, new ZomboldModel(context.bakeLayer(KoboldsClient.ZOMBOLD)), 0.36f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new KoboldZombieEyesLayer(this));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_INNER)), (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_OUTER)), context.getModelManager()));
    }

    public ResourceLocation getTextureLocation(KoboldZombie zombo) {
        if (zombo.getName().getString().equals("James") && zombo.getZomboType().equals("enchanter")) {
            return ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/undead/zombie_james.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/undead/zombie_" + zombo.getZomboType() + ".png"));
    }

    protected boolean isShaking(KoboldZombie zombo) {
        return zombo.isConvert();
    }

    public void render(KoboldZombie zombo, float f1, float f2, PoseStack pose, MultiBufferSource buffer, int i) {
        pose.pushPose();
        pose.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        pose.scale(scale, scale, scale);
        super.render((LivingEntity)zombo, f1, f2, pose, buffer, i);
        pose.popPose();
    }
}

