/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;

public class KoboldArmorModel
extends HumanoidModel {
    public static ArmorModelSet<LayerDefinition> KOBOLD_ARMOR_LAYER = KoboldArmorModel.createArmorSet().map(mesh -> LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32));

    public KoboldArmorModel(ModelPart part) {
        super(part);
    }

    public static LayerDefinition createHeadLayer() {
        return (LayerDefinition)KOBOLD_ARMOR_LAYER.head();
    }

    public static LayerDefinition createBodyLayer() {
        return (LayerDefinition)KOBOLD_ARMOR_LAYER.chest();
    }

    public static LayerDefinition createLegsLayer() {
        return (LayerDefinition)KOBOLD_ARMOR_LAYER.legs();
    }

    public static LayerDefinition createBootsLayer() {
        return (LayerDefinition)KOBOLD_ARMOR_LAYER.feet();
    }

    public static ArmorModelSet<MeshDefinition> createArmorSet() {
        return KoboldArmorModel.createArmorSet(KoboldArmorModel::createBaseArmor);
    }

    public static ArmorModelSet<MeshDefinition> createArmorSet(Function<CubeDeformation, MeshDefinition> base) {
        MeshDefinition head = base.apply(new CubeDeformation(0.0f));
        head.getRoot().retainPartsAndChildren(Set.of("head"));
        MeshDefinition body = base.apply(new CubeDeformation(0.1f));
        body.getRoot().retainExactParts(Set.of("body", "left_arm", "right_arm"));
        MeshDefinition legs = base.apply(new CubeDeformation(0.05f));
        legs.getRoot().retainExactParts(Set.of("left_leg", "right_leg"));
        MeshDefinition boots = base.apply(new CubeDeformation(0.1f));
        boots.getRoot().retainExactParts(Set.of("left_leg", "right_leg"));
        return new ArmorModelSet((Object)head, (Object)body, (Object)legs, (Object)boots);
    }

    private static MeshDefinition createBaseArmor(CubeDeformation cube) {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)cube, (float)0.0f);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.5f, -4.0f, 8.0f, 8.0f, 8.0f, cube.extend(-0.3f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-0.5f));
        root.getChild("head").addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -7.5f, -4.0f, 8.0f, 8.0f, 8.0f, cube.extend(-0.25f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-0.5f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 11.0f, 4.0f, cube.extend(0.05f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, -1.55f, -2.0f, 4.0f, 12.0f, 4.0f, cube.extend(-0.35f)).mirror(false), PartPose.offset((float)1.5f, (float)14.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, -1.55f, -2.0f, 4.0f, 12.0f, 4.0f, cube.extend(-0.35f)), PartPose.offset((float)-1.5f, (float)14.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(0.0f, -1.55f, -2.0f, 4.0f, 12.0f, 4.0f, cube.extend(-0.35f)).mirror(false), PartPose.offset((float)2.5f, (float)5.0f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-4.0f, -1.55f, -2.0f, 4.0f, 12.0f, 4.0f, cube.extend(-0.35f)), PartPose.offset((float)-2.5f, (float)5.0f, (float)0.0f));
        return mesh;
    }
}

