/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldChild;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.events.KoboldEvent;
import net.salju.kobolds.events.KoboldsManager;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.init.KoboldsPotions;
import net.salju.kobolds.init.KoboldsSounds;
import net.salju.kobolds.init.KoboldsTags;

public abstract class AbstractKoboldEntity
extends AgeableMob
implements CrossbowAttackMob,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.defineId(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_DIAMOND_EYES = SynchedEntityData.defineId(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_DRAGON_COLOR = SynchedEntityData.defineId(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID thrownTrident;
    private UUID dragonFriend;
    private ItemStack primary = ItemStack.EMPTY;
    private ItemStack secondary = ItemStack.EMPTY;
    private int cooldown;

    protected AbstractKoboldEntity(EntityType<? extends AgeableMob> type, Level world) {
        super(type, world);
        this.setCanPickUpLoot(true);
        this.setPersistenceRequired();
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.getPrimary().isEmpty()) {
            tag.put("Primary", this.getPrimary().save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
        if (!this.getSecondary().isEmpty()) {
            tag.put("Secondary", this.getSecondary().save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
        if (this.getTridentReference() != null) {
            tag.putUUID("ThrownTrident", this.getTridentReference());
        }
        if (this.getDragonReference() != null) {
            tag.putUUID("DragonFriend", this.getDragonReference());
        }
        tag.putInt("DC", this.getDragonColor());
        tag.putInt("CD", this.getCD());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Primary")) {
            this.setPrimary(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)tag.getCompound("Primary")));
        }
        if (tag.contains("Secondary")) {
            this.setSecondary(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)tag.getCompound("Secondary")));
        }
        if (tag.contains("ThrownTrident")) {
            this.thrownTrident = tag.getUUID("ThrownTrident");
        }
        if (tag.contains("DragonFriend")) {
            this.dragonFriend = tag.getUUID("DragonFriend");
        }
        this.setDragonColor(tag.getInt("DC"));
        this.setCD(tag.getInt("CD"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CHARGING_STATE, (Object)false);
        builder.define(DATA_DIAMOND_EYES, (Object)false);
        builder.define(DATA_DRAGON_COLOR, (Object)0);
    }

    public void performRangedAttack(LivingEntity target, float f) {
        InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, stack -> stack instanceof CrossbowItem || stack instanceof BowItem || stack instanceof TridentItem);
        if (this.getItemInHand(hand).getItem() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, 2.0f);
        } else if (this.getItemInHand(hand).getItem() instanceof BowItem) {
            AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)this.getProjectile(this.getItemInHand(hand)), (float)f, (ItemStack)this.getItemInHand(hand));
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - arrow.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            arrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)arrow);
        } else if (this.getItemInHand(hand).getItem() instanceof TridentItem) {
            this.setSecondary(this.getItemInHand(hand));
            ThrownTrident proj = new ThrownTrident(this.level(), (LivingEntity)this, this.getSecondary());
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - proj.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            proj.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.DROWNED_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)proj);
            this.setItemInHand(InteractionHand.MAIN_HAND, this.getPrimary());
            this.setTrident(proj);
            this.setCD(1200);
        }
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(DATA_CHARGING_STATE);
    }

    public void setChargingCrossbow(boolean check) {
        this.entityData.set(DATA_CHARGING_STATE, (Object)check);
    }

    public ItemStack equipItemIfPossible(ItemStack stack) {
        EquipmentSlot slot = this.getEquipmentSlotForItem(stack);
        ItemStack current = this.getItemBySlot(slot);
        boolean flag = this.canReplaceCurrentItem(stack, current);
        if (stack.is(Items.EMERALD)) {
            slot = EquipmentSlot.OFFHAND;
            current = this.getItemBySlot(slot);
            flag = this.canReplaceCurrentItem(stack, current);
        }
        if (flag && this.canHoldItem(stack)) {
            if (!current.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < (double)this.getEquipmentDropChance(slot)) {
                this.spawnAtLocation(current);
            }
            if (stack.is(Items.EMERALD) && stack.getCount() > 1) {
                stack = stack.split(1);
            }
            if (slot.isArmor() && stack.getCount() > 1) {
                ItemStack copy = stack.copyWithCount(1);
                this.setItemSlotAndDropWhenKilled(slot, copy);
                return copy;
            }
            this.setItemSlotAndDropWhenKilled(slot, stack);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    protected boolean canReplaceCurrentItem(ItemStack drop, ItemStack hand) {
        if (EnchantmentHelper.hasTag((ItemStack)drop, (TagKey)EnchantmentTags.CURSE)) {
            return false;
        }
        if (drop.getItem() instanceof TridentItem) {
            if (hand.getItem() instanceof TridentItem && this.canReplaceEqualItem(drop, hand)) {
                this.setSecondary(drop);
                return true;
            }
            if (this.getSecondary().isEmpty()) {
                this.setPrimary(this.getMainHandItem());
                this.setSecondary(drop);
                this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                return true;
            }
        } else {
            if (this.isPreferredWeapon(drop)) {
                if (this.getMainHandItem().getItem() instanceof TridentItem) {
                    return false;
                }
                if (this.isPreferredWeapon(hand)) {
                    return this.canReplaceEqualItem(drop, hand);
                }
                return true;
            }
            if (this.isPreferredWeapon(hand)) {
                return false;
            }
            if (drop.getItem() instanceof ShieldItem) {
                if (hand.getItem() instanceof ShieldItem) {
                    this.setSecondary(drop);
                    return this.canReplaceEqualItem(drop, hand);
                }
                if (hand.isEmpty() && this.getSecondary().isEmpty()) {
                    this.setSecondary(drop);
                    return true;
                }
            } else {
                if (drop.is(Items.EMERALD) && hand.isEmpty() && this.getType().is(KoboldsTags.TRADERS)) {
                    return true;
                }
                if (drop.is(KoboldsTags.ARMOR)) {
                    return hand.isEmpty() || this.canReplaceEqualItem(drop, hand);
                }
            }
        }
        return false;
    }

    public boolean canReplaceEqualItem(ItemStack drop, ItemStack hand) {
        if (drop.isEnchanted()) {
            if (hand.isEnchanted()) {
                int id = 0;
                ItemEnchantments.Mutable dropMap = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)drop));
                for (Holder e : dropMap.keySet()) {
                    if (e.is(KoboldsTags.ENCHS)) {
                        id += 5 * dropMap.getLevel(e);
                        continue;
                    }
                    id += dropMap.getLevel(e);
                }
                int ih = 0;
                ItemEnchantments.Mutable handMap = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)hand));
                for (Holder e : handMap.keySet()) {
                    if (e.is(KoboldsTags.ENCHS)) {
                        ih += 5 * handMap.getLevel(e);
                        continue;
                    }
                    ih += handMap.getLevel(e);
                }
                if (id > ih) {
                    return true;
                }
                if (this.isPreferredWeapon(drop) && id == ih) {
                    return drop.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND) > hand.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND);
                }
            }
            return !hand.isEnchanted();
        }
        if (this.isPreferredWeapon(drop) && !hand.isEnchanted()) {
            return drop.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND) > hand.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND);
        }
        return super.canReplaceEqualItem(drop, hand);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public SoundEvent getAmbientSound() {
        return this.isBaby() ? (SoundEvent)KoboldsSounds.KOBOLD_YIP.get() : (SoundEvent)KoboldsSounds.KOBOLD_IDLE.get();
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return this.isBlocking() ? SoundEvents.SHIELD_BLOCK : (SoundEvent)KoboldsSounds.KOBOLD_HURT.get();
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)KoboldsSounds.KOBOLD_DEATH.get();
    }

    public void die(DamageSource source) {
        if (source.getDirectEntity() instanceof Zombie && !this.isBaby()) {
            this.playSound(SoundEvents.ZOMBIE_VILLAGER_CONVERTED, 1.0f, 1.0f);
            if (this.level() instanceof ServerLevel) {
                if (this.getOffhandItem().is(Items.POTION)) {
                    this.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                }
                KoboldZombie zombo = (KoboldZombie)this.convertTo((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get(), true);
                zombo.setZombo(this);
            }
        }
        super.die(source);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack gem = player.getItemInHand(hand).copy();
        if (this.isAlive()) {
            if (player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
                this.playSound((SoundEvent)KoboldsSounds.KOBOLD_PURR.get(), 1.0f, this.isBaby() ? 1.2f : 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!this.isBaby()) {
                if (gem.is((Item)KoboldsItems.KOBOLD_SPAWN_EGG.get())) {
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)level;
                        ((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).spawn(lvl, BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()), MobSpawnType.BREEDING);
                    }
                    if (!player.isCreative()) {
                        player.getItemInHand(hand).shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (gem.is(Items.AMETHYST_SHARD)) {
                    if (this.isEffectiveAi() && this.getAge() <= 0) {
                        if (this.getHealth() < this.getMaxHealth()) {
                            this.setAge(1200);
                            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1200, 0));
                        } else {
                            this.setAge(20000);
                        }
                        if (!player.isCreative()) {
                            player.getItemInHand(hand).shrink(1);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.getMainHandItem().isEmpty() || this.getOffhandItem().isEmpty()) {
                    if (gem.getItem() instanceof AxeItem && hand != InteractionHand.MAIN_HAND && this instanceof Kobold) {
                        if (this.isEffectiveAi()) {
                            this.setItemInHand(InteractionHand.OFF_HAND, gem);
                            if (!player.isCreative()) {
                                player.getItemInHand(hand).shrink(1);
                            }
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (gem.is(Items.EMERALD) && this.getType().is(KoboldsTags.TRADERS)) {
                        if (this.isEffectiveAi()) {
                            gem.setCount(1);
                            this.setItemInHand(InteractionHand.OFF_HAND, gem);
                            if (!player.isCreative()) {
                                player.getItemInHand(hand).shrink(1);
                            }
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.mobInteract(player, hand);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        SpawnGroupData spawn = super.finalizeSpawn(world, difficulty, reason, data);
        this.populateDefaultEquipmentSlots(world.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(world, world.getRandom(), difficulty);
        this.setBaby(this.isBaby());
        if (this.getType().is(KoboldsTags.DRAGON)) {
            KoboldEvent.DragonEvent event = KoboldsManager.onGetDragonEvent(this);
            this.setDragonColor(event.getColorInt());
            if (event.getDragon() != null) {
                this.setDragonFriend(event.getDragon().getUUID());
            }
        }
        return spawn;
    }

    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        this.setPrimary(this.getMainHandItem());
        if (this.getType().equals(KoboldsMobs.KOBOLD_PIRATE.get()) && Math.random() >= 0.75) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.TRIDENT));
            this.setSecondary(this.getMainHandItem());
        } else {
            this.setSecondary(this.getOffhandItem());
        }
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
    }

    public ItemStack getProjectile(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
            ItemStack extra = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)weapon.getSupportedHeldProjectiles(stack));
            return extra.isEmpty() ? new ItemStack((ItemLike)Items.ARROW) : extra;
        }
        return super.getProjectile(stack);
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            if (this.isAlive() && this.isEffectiveAi()) {
                this.checkTrident(lvl);
                this.checkDragon(lvl);
                if (this.getCD() > 0) {
                    this.setCD(this.getCD() - 1);
                }
                if (this.getHealth() < 12.0f && !this.hasEffect(MobEffects.REGENERATION)) {
                    this.givePotion(PotionContents.createItemStack((Item)Items.POTION, KoboldsPotions.AMETHYST));
                }
                if (this.getAge() > 0) {
                    if (this.canBreed()) {
                        AbstractKoboldEntity target = (AbstractKoboldEntity)lvl.getNearestEntity(AbstractKoboldEntity.class, TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight(), (LivingEntity)this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(8.0));
                        if (Mth.nextInt((RandomSource)this.random, (int)1, (int)10) > 8) {
                            double d = this.random.nextGaussian() * 0.02;
                            lvl.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 3, d, d, d, 0.0);
                        }
                        if (target != null && !target.is((Entity)this) && target.canBreed()) {
                            if ((double)this.distanceTo((Entity)target) >= 1.0) {
                                this.getNavigation().moveTo((Entity)target, 1.0);
                            } else if ((double)this.distanceTo((Entity)target) < 1.0) {
                                KoboldChild child = this.getBreedOffspring(lvl, target);
                                if (child != null) {
                                    child.setDragonColor(this.getDragonColor());
                                    child.setDragonFriend(this.getDragonReference());
                                }
                                target.setAge(18000);
                                this.setAge(18000);
                            }
                        }
                    }
                    if (!this.isDiamond()) {
                        this.getEntityData().set(DATA_DIAMOND_EYES, (Object)true);
                    }
                } else if (this.isDiamond()) {
                    this.getEntityData().set(DATA_DIAMOND_EYES, (Object)false);
                }
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity atk;
        Entity entity;
        if (!this.level().isClientSide() && this.isAlive() && this.isEffectiveAi()) {
            if ((source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.LAVA)) && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                this.givePotion(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_FIRE_RESISTANCE));
            } else if (source.is(DamageTypes.DROWN) && !this.hasEffect(MobEffects.WATER_BREATHING)) {
                this.givePotion(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_WATER_BREATHING));
            }
        }
        if (this.isBlocking() && (entity = source.getDirectEntity()) instanceof LivingEntity && (atk = (LivingEntity)entity).canDisableShield()) {
            this.setCD(100);
        }
        if (source.getEntity() != null && this.getDragonReference() != null && source.getEntity().getUUID().equals(this.getDragonReference())) {
            return false;
        }
        return !(source.getEntity() instanceof AbstractKoboldEntity) && !source.is(DamageTypes.CAMPFIRE) && super.hurt(source, amount);
    }

    public boolean isBaby() {
        return false;
    }

    public boolean canBreed() {
        return this.getAge() > 18000;
    }

    public KoboldChild getBreedOffspring(ServerLevel lvl, AgeableMob target) {
        return (KoboldChild)((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).spawn(lvl, this.blockPosition(), MobSpawnType.BREEDING);
    }

    public ItemStack getPrimary() {
        return this.primary;
    }

    public ItemStack getSecondary() {
        return this.secondary;
    }

    public void setPrimary(ItemStack stack) {
        this.primary = stack;
    }

    public void setSecondary(ItemStack stack) {
        this.secondary = stack;
    }

    public void givePotion(ItemStack stack) {
        if (this.getOffhandItem().isEmpty()) {
            this.setItemInHand(InteractionHand.OFF_HAND, stack);
        }
    }

    public void checkDragon(ServerLevel lvl) {
        LivingEntity dragon;
        Entity entity;
        if (this.getDragonReference() != null && (entity = lvl.getEntity(this.getDragonReference())) instanceof LivingEntity && (dragon = (LivingEntity)entity).isAlive() && this.distanceTo((Entity)dragon) >= 64.0f && this.getTarget() == null && !this.getNavigation().isInProgress()) {
            this.getNavigation().moveTo((Entity)dragon, 1.2);
        }
    }

    public void checkTrident(ServerLevel lvl) {
        ThrownTrident proj;
        Entity entity;
        if (this.getTridentReference() != null && (entity = lvl.getEntity(this.getTridentReference())) instanceof ThrownTrident && (proj = (ThrownTrident)entity).getOwner() != null) {
            if (proj.getOwner().is((Entity)this) && (this.getCD() <= 1195 || proj.isNoPhysics())) {
                if (this.distanceTo((Entity)proj) < 2.5f || this.getCD() <= 1) {
                    this.giveTrident(proj);
                } else if (this.distanceTo((Entity)proj) < 32.0f && this.getTarget() == null && !this.getNavigation().isInProgress()) {
                    this.getNavigation().moveTo((Entity)proj, 1.0);
                }
            }
        } else if (this.getTridentReference() != null && this.getCD() <= 1) {
            this.giveTrident(null);
        }
    }

    protected void giveTrident(@Nullable ThrownTrident proj) {
        this.setPrimary(this.getMainHandItem());
        this.setItemInHand(InteractionHand.MAIN_HAND, this.getSecondary());
        this.setTrident(null);
        if (this.getCD() > 1 && proj != null) {
            this.setCD(0);
            proj.discard();
        }
    }

    public void setDragonColor(int i) {
        this.getEntityData().set(DATA_DRAGON_COLOR, (Object)i);
    }

    public void setDragonFriend(UUID target) {
        this.dragonFriend = target;
    }

    public void setCD(int i) {
        this.cooldown = i;
    }

    public void setTrident(@Nullable ThrownTrident proj) {
        this.thrownTrident = proj != null ? proj.getUUID() : null;
    }

    public boolean isDiamond() {
        return (Boolean)this.getEntityData().get(DATA_DIAMOND_EYES);
    }

    public int getDragonColor() {
        return (Integer)this.getEntityData().get(DATA_DRAGON_COLOR);
    }

    public int getCD() {
        return this.cooldown;
    }

    public boolean isPreferredWeapon(ItemStack stack) {
        return stack.is(KoboldsTags.BASIC);
    }

    @Nullable
    public UUID getTridentReference() {
        return this.thrownTrident;
    }

    @Nullable
    public UUID getDragonReference() {
        return this.dragonFriend;
    }
}

