/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.salju.kobolds.compat.Supplementaries;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.ai.KoboldAttackSelector;
import net.salju.kobolds.entity.ai.KoboldBowGoal;
import net.salju.kobolds.entity.ai.KoboldCrossbowGoal;
import net.salju.kobolds.entity.ai.KoboldMeleeGoal;
import net.salju.kobolds.entity.ai.KoboldPotionGoal;
import net.salju.kobolds.entity.ai.KoboldRevengeGoal;
import net.salju.kobolds.entity.ai.KoboldShieldGoal;
import net.salju.kobolds.entity.ai.KoboldTargetGoal;
import net.salju.kobolds.entity.ai.KoboldTradeGoal;
import net.salju.kobolds.entity.ai.KoboldTridentGoal;
import net.salju.kobolds.init.KoboldsItems;

public class KoboldCaptain
extends AbstractKoboldEntity {
    public KoboldCaptain(EntityType<KoboldCaptain> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(0, (Goal)new KoboldRevengeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldPotionGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldShieldGoal(this));
        if (ModList.get().isLoaded("supplementaries")) {
            Supplementaries.addGoals(this);
        }
        this.goalSelector.addGoal(1, (Goal)new KoboldTridentGoal(this, 1.0, 40, 12.0f));
        this.goalSelector.addGoal(1, new KoboldCrossbowGoal<KoboldCaptain>(this, 1.0, 12.0f));
        this.goalSelector.addGoal(1, new KoboldBowGoal<KoboldCaptain>(this, 1.0, 20, 15.0f));
        this.goalSelector.addGoal(1, (Goal)new KoboldTradeGoal(this, "gameplay/captain_loot"));
        this.goalSelector.addGoal(2, new KoboldMeleeGoal<KoboldCaptain>(this, 1.2, false));
        this.targetSelector.addGoal(2, new KoboldTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, new KoboldAttackSelector(this)));
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
        super.populateDefaultEquipmentSlots(randy, souls);
    }
}

