/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldPirateEyesLayer<S extends AbstractKoboldEntity, M extends KoboldModel<S>>
extends EyesLayer<S, M> {
    public KoboldPirateEyesLayer(RenderLayerParent<S, M> parent) {
        super(parent);
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int i, AbstractKoboldEntity kobold, float f1, float f2, float f3, float f4, float f5, float f6) {
        ((KoboldModel)this.getParentModel()).renderToBuffer(pose, buffer.getBuffer(this.renderSpecialType(this.getKoboldEyes(kobold))), i, OverlayTexture.NO_OVERLAY);
    }

    public RenderType renderType() {
        return RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/eyes/base_pirate.png"));
    }

    public RenderType renderSpecialType(String type) {
        if (!type.isEmpty()) {
            return RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/eyes/" + type + ".png")));
        }
        return this.renderType();
    }

    public String getKoboldEyes(AbstractKoboldEntity kobold) {
        if (kobold.isDiamond()) {
            return "diamond_pirate";
        }
        if (kobold.getDragonColor() >= 1) {
            return "dragon/pirate/" + kobold.getDragonColor();
        }
        return "base_pirate";
    }
}

