/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class AbstractKoboldSkeleton
extends AbstractSkeleton
implements CrossbowAttackMob,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.defineId(AbstractKoboldSkeleton.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public AbstractKoboldSkeleton(EntityType<? extends AbstractKoboldSkeleton> type, Level world) {
        super(type, world);
    }

    public void performRangedAttack(LivingEntity target, float f) {
        if (this.getMainHandItem().getItem() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, 6.0f);
        } else if (this.getMainHandItem().getItem() instanceof BowItem) {
            super.performRangedAttack(target, f);
        }
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public void setChargingCrossbow(boolean charging) {
        this.entityData.set(DATA_CHARGING_STATE, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(DATA_CHARGING_STATE);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CHARGING_STATE, (Object)false);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        SpawnGroupData spawndata = super.finalizeSpawn(world, difficulty, reason, data);
        this.populateDefaultEquipmentSlots(world.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(world, world.getRandom(), difficulty);
        return spawndata;
    }
}

