/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.ai.KoboldMeleeGoal;
import net.salju.kobolds.entity.ai.KoboldPotionGoal;
import net.salju.kobolds.entity.ai.KoboldRevengeGoal;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsSounds;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldRascal
extends AbstractKoboldEntity {
    public KoboldRascal(EntityType<KoboldRascal> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(0, (Goal)new KoboldRevengeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldPotionGoal(this));
        this.goalSelector.addGoal(2, new KoboldMeleeGoal<KoboldRascal>(this, 1.2, false));
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.hasEffect(MobEffects.INVISIBILITY) && !this.getEffect(MobEffects.INVISIBILITY).endsWithin(9600) && !this.level().isClientSide()) {
            player.swing(hand);
            this.removeEffect(MobEffects.INVISIBILITY);
            this.swing(InteractionHand.MAIN_HAND, true);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                this.playSound((SoundEvent)KoboldsSounds.KOBOLD_TRADE.get(), 1.0f, 1.0f);
                ItemStack stack = new ItemStack((ItemLike)Items.BUNDLE);
                if (Math.random() >= 0.85) {
                    stack = new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_PICKAXE.get());
                    stack.setDamageValue(Mth.nextInt((RandomSource)this.getRandom(), (int)52, (int)716));
                    EnchantmentHelper.enchantItem((RandomSource)this.getRandom(), (ItemStack)stack, (int)Mth.nextInt((RandomSource)this.getRandom(), (int)18, (int)32), (RegistryAccess)this.level().registryAccess(), Optional.empty());
                } else {
                    ArrayList<ItemStack> data = new ArrayList<ItemStack>();
                    for (int i = 0; i < Mth.nextInt((RandomSource)this.getRandom(), (int)7, (int)38); ++i) {
                        int e;
                        int g = Mth.nextInt((RandomSource)this.getRandom(), (int)0, (int)7);
                        ItemStack gem = this.getStack(g);
                        if (Math.random() >= 0.98) {
                            gem = new ItemStack((ItemLike)Items.DIAMOND);
                        }
                        if ((e = this.getMatchingItem(gem, data)) != -1) {
                            ItemStack copy = (ItemStack)data.remove(e);
                            copy.grow(gem.getCount());
                            data.addFirst(copy);
                            continue;
                        }
                        data.addFirst(gem);
                    }
                    stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(data));
                }
                ItemEntity reward = new ItemEntity((Level)lvl, this.getX(), this.getY(), this.getZ(), stack);
                reward.setPickUpDelay(10);
                lvl.addFreshEntity((Entity)reward);
            }
        }
        for (AbstractKoboldEntity kobold : this.level().getEntitiesOfClass(AbstractKoboldEntity.class, this.getBoundingBox().inflate(128.0))) {
            if (kobold == null || kobold.is((Entity)this)) continue;
            this.getNavigation().moveTo((Entity)kobold, 1.2);
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data) {
        SpawnGroupData spawn = super.finalizeSpawn(world, difficulty, reason, data);
        this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 24000, 0));
        return spawn;
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
        super.populateDefaultEquipmentSlots(randy, souls);
    }

    @Override
    protected boolean canReplaceCurrentItem(ItemStack drop, ItemStack hand) {
        if (drop.is(ItemTags.SWORDS) || drop.is(KoboldsTags.ARMOR)) {
            return super.canReplaceCurrentItem(drop, hand);
        }
        return false;
    }

    public int getMatchingItem(ItemStack stack, List<ItemStack> data) {
        if (!stack.isStackable()) {
            return -1;
        }
        for (int i = 0; i < data.size(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)data.get(i), (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public ItemStack getStack(int i) {
        HashMap<Integer, Item> stackMap = new HashMap<Integer, Item>();
        stackMap.put(0, Items.COAL);
        stackMap.put(1, Items.AMETHYST_SHARD);
        stackMap.put(2, Items.EMERALD);
        stackMap.put(3, Items.RAW_COPPER);
        stackMap.put(4, Items.RAW_IRON);
        stackMap.put(5, Items.RAW_GOLD);
        stackMap.put(6, Items.LAPIS_LAZULI);
        stackMap.put(7, Items.REDSTONE);
        return new ItemStack((ItemLike)stackMap.getOrDefault(i, Items.EMERALD));
    }
}

