/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.salju.kobolds.Kobolds;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldWarriorGoal
extends Goal {
    public final AbstractKoboldEntity kobold;

    public KoboldWarriorGoal(AbstractKoboldEntity kobold) {
        this.kobold = kobold;
    }

    public boolean canUse() {
        return this.isHoldingAxe();
    }

    public void start() {
        this.kobold.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 600, 10, false, false));
        Kobolds.queueServerWork(600, () -> {
            Level patt0$temp = this.kobold.level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)patt0$temp;
                ItemEntity primary = new ItemEntity((Level)lvl, this.kobold.getX(), this.kobold.getY(), this.kobold.getZ(), this.kobold.getPrimary());
                primary.setPickUpDelay(10);
                lvl.addFreshEntity((Entity)primary);
                if (!this.kobold.getSecondary().isEmpty()) {
                    ItemEntity secondary = new ItemEntity((Level)lvl, this.kobold.getX(), this.kobold.getY(), this.kobold.getZ(), this.kobold.getSecondary());
                    secondary.setPickUpDelay(10);
                    lvl.addFreshEntity((Entity)secondary);
                }
                this.kobold.setItemSlot(EquipmentSlot.MAINHAND, this.kobold.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.kobold, item -> item instanceof AxeItem)));
                this.kobold.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
                this.kobold.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
                this.kobold.setPrimary(this.kobold.getMainHandItem());
                this.kobold.setSecondary(this.kobold.getOffhandItem());
                this.kobold.convertTo((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), true);
            }
        });
    }

    private boolean isHoldingAxe() {
        return this.kobold.isHolding(stack -> stack.getItem() instanceof AxeItem);
    }
}

