/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.client.renderer.layers.KoboldEyesLayer;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldEnchanterRenderer
extends MobRenderer<AbstractKoboldEntity, AbstractKoboldState, KoboldModel<AbstractKoboldState>> {
    public KoboldEnchanterRenderer(EntityRendererProvider.Context context) {
        super(context, new KoboldModel(context.bakeLayer(KoboldsClient.KOBOLD)), 0.36f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new KoboldEyesLayer(this));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, ArmorModelSet.bake(KoboldsClient.KOBOLD_ARMOR, (EntityModelSet)context.getModelSet(), KoboldModel::new), ArmorModelSet.bake(KoboldsClient.KOBOLD_ARMOR, (EntityModelSet)context.getModelSet(), KoboldModel::new), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(AbstractKoboldState kobold) {
        return kobold.texture;
    }

    public AbstractKoboldState createRenderState() {
        return new AbstractKoboldState();
    }

    public void extractRenderState(AbstractKoboldEntity kobold, AbstractKoboldState state, float f1) {
        super.extractRenderState((LivingEntity)kobold, (LivingEntityRenderState)state, f1);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)kobold, (HumanoidRenderState)state, (float)f1, (ItemModelResolver)this.itemModelResolver);
        state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/" + this.getKoboldType(kobold) + ".png"));
        state.isDiamond = kobold.isDiamond();
        state.isLeftHanded = kobold.isLeftHanded();
        state.rightStack = kobold.getItemHeldByArm(HumanoidArm.RIGHT);
        state.leftStack = kobold.getItemHeldByArm(HumanoidArm.LEFT);
        state.dragonColor = kobold.getDragonColor();
    }

    public void submit(AbstractKoboldState kobold, PoseStack pose, SubmitNodeCollector buffer, CameraRenderState c) {
        pose.pushPose();
        pose.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        pose.scale(scale, scale, scale);
        super.submit((LivingEntityRenderState)kobold, pose, buffer, c);
        pose.popPose();
    }

    public String getKoboldType(AbstractKoboldEntity kobold) {
        if (kobold.getName().getString().equals("James")) {
            return "special/james";
        }
        if (kobold.getName().getString().equals("Popper")) {
            return "special/popper";
        }
        if (kobold.getDragonColor() >= 1) {
            return "special/dragon/enchanter/" + kobold.getDragonColor();
        }
        return "kobolds/enchanter";
    }
}

