/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.fml.loading.toposort.TopologicalSort;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.fluids.crafting.FluidIngredientType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModuleContainer;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.LoadingContext;
import snownee.kiwi.ModContext;
import snownee.kiwi.RegistryLookup;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.build.KiwiMetadata;
import snownee.kiwi.build.KiwiMetadataParser;
import snownee.kiwi.command.KiwiCommand;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfig;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.config.NeoClothConfigIntegration;
import snownee.kiwi.loader.ClientInitializer;
import snownee.kiwi.loader.KiwiMetadataLoader;
import snownee.kiwi.loader.NeoDevEnvMetadataLoader;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.network.KNetworking;
import snownee.kiwi.util.KUtil;

@Mod(value="kiwi")
public class Kiwi {
    public static final String ID = "kiwi";
    public static final RegistryLookup registryLookup = new RegistryLookup();
    static final Marker MARKER = MarkerFactory.getMarker((String)"INIT");
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Map<ResourceLocation, Boolean> defaultOptions = Maps.newHashMap();
    private static Multimap<String, KiwiAnnotationData> moduleData = ArrayListMultimap.create();
    private static Map<KiwiAnnotationData, String> conditions = Maps.newHashMap();
    private static LoadingStage stage = LoadingStage.UNINITED;
    private static final Map<String, ResourceKey<CreativeModeTab>> GROUPS = Maps.newHashMap();
    public static boolean enableDataModule;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    private static boolean shouldLoad(KiwiAnnotationData annotationData, String dist) {
        try {
            String target = annotationData.getTarget();
            if (Platform.isProduction() && target.startsWith("snownee.kiwi.test.")) {
                return false;
            }
            ClassNode clazz = new ClassNode(458752);
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(target.replace('.', '/') + ".class");
            ClassReader classReader = new ClassReader(is);
            classReader.accept((ClassVisitor)clazz, 0);
            if (clazz.visibleAnnotations != null) {
                String ONLYIN = Type.getDescriptor(OnlyIn.class);
                for (AnnotationNode node : clazz.visibleAnnotations) {
                    int i;
                    if (node.values == null || !ONLYIN.equals(node.desc) || (i = node.values.indexOf("value")) == -1 || node.values.get(i + 1).equals(dist)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Kiwi(IEventBus modEventBus) throws Exception {
        if (stage != LoadingStage.UNINITED) {
            return;
        }
        stage = LoadingStage.CONSTRUCTING;
        try {
            Kiwi.registerRegistries();
            Kiwi.registerTabs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap classOptionalMap = Maps.newHashMap();
        String dist = Platform.isPhysicalClient() ? "client" : "server";
        List<String> mods = ModList.get().getMods().stream().map(IModInfo::getModId).toList();
        KiwiMetadataParser metadataParser = new KiwiMetadataParser();
        for (String mod : mods) {
            boolean yamlLoader;
            Record loader;
            KiwiMetadata metadata;
            if ("neoforge".equals(mod) || (metadata = (KiwiMetadata)(loader = (yamlLoader = Platform.isProduction() || System.getProperties().containsKey("kiwi.disableDevEnvMetadataLoader")) ? new KiwiMetadataLoader(mod) : new NeoDevEnvMetadataLoader(mod)).apply(metadataParser)) == null) continue;
            if (!metadata.clientOnly()) {
                Kiwi.enableDataModule();
            }
            for (KiwiAnnotationData module : metadata.get("modules")) {
                if (!Kiwi.shouldLoad(module, dist)) continue;
                moduleData.put((Object)mod, (Object)module);
            }
            for (KiwiAnnotationData optional : metadata.get("optionals")) {
                if (!Kiwi.shouldLoad(optional, dist)) continue;
                classOptionalMap.put(optional.getTarget(), optional);
            }
            for (KiwiAnnotationData condition : metadata.get("conditions")) {
                if (!Kiwi.shouldLoad(condition, dist)) continue;
                conditions.put(condition, mod);
            }
            for (KiwiAnnotationData config : metadata.get("configs")) {
                if (!Kiwi.shouldLoad(config, dist)) continue;
                KiwiConfig.ConfigType type = null;
                try {
                    type = KiwiConfig.ConfigType.valueOf((String)config.getData().get("type"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                KiwiConfig.ConfigType configType = type = type == null ? KiwiConfig.ConfigType.COMMON : type;
                if (type == KiwiConfig.ConfigType.CLIENT && !Platform.isPhysicalClient() && !Platform.isDataGen()) continue;
                try {
                    boolean hasModules;
                    Class<?> clazz = Class.forName(config.getTarget());
                    String fileName = (String)config.getData().get("value");
                    boolean bl = hasModules = type == KiwiConfig.ConfigType.COMMON && Strings.isNullOrEmpty((String)fileName);
                    if (Strings.isNullOrEmpty((String)fileName)) {
                        fileName = String.format("%s-%s", mod, type.extension());
                    }
                    new ConfigHandler(mod, fileName, type, clazz, hasModules);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error(MARKER, "Failed to load config class {}", (Object)config.getTarget());
                }
            }
            KNetworking networking = new KNetworking(modEventBus);
            for (KiwiAnnotationData packet : metadata.get("packets")) {
                if (!Kiwi.shouldLoad(packet, dist)) continue;
                networking.processClass(packet);
            }
        }
        LOGGER.info(MARKER, "Processing " + moduleData.size() + " KiwiModule annotations");
        for (Map.Entry entry : moduleData.entries()) {
            Boolean defaultEnabled;
            String modid;
            KiwiAnnotationData optional = (KiwiAnnotationData)classOptionalMap.get(((KiwiAnnotationData)entry.getValue()).getTarget());
            if (optional == null || !Platform.isModLoaded(modid = (String)entry.getKey())) continue;
            String name = (String)((KiwiAnnotationData)entry.getValue()).getData().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if ((defaultEnabled = (Boolean)optional.getData().get("defaultEnabled")) == null) {
                defaultEnabled = Boolean.TRUE;
            }
            defaultOptions.put(ResourceLocation.fromNamespaceAndPath((String)modid, (String)name), defaultEnabled);
        }
        KiwiConfigManager.init();
        if (Platform.isPhysicalClient() && Platform.isModLoaded("cloth_config")) {
            NeoClothConfigIntegration.init();
        }
        modEventBus.addListener(this::init);
        modEventBus.addListener(this::postInit);
        modEventBus.addListener(this::loadComplete);
        if (Platform.isPhysicalClient()) {
            RenderLayerEnum.CUTOUT.value = RenderType.cutout();
            RenderLayerEnum.CUTOUT_MIPPED.value = RenderType.cutoutMipped();
            RenderLayerEnum.TRANSLUCENT.value = RenderType.translucent();
            NeoForge.EVENT_BUS.register(ClientInitializer.class);
        }
        NeoForge.EVENT_BUS.addListener(this::onCommandsRegister);
        NeoForge.EVENT_BUS.addListener(this::onAttachEntity);
        stage = LoadingStage.CONSTRUCTED;
    }

    public static void preInit() {
        Object moduleLoadingQueue;
        Iterator module;
        if (stage != LoadingStage.CONSTRUCTED) {
            return;
        }
        HashSet disabledModules = Sets.newHashSet();
        conditions.forEach((k, v) -> {
            try {
                Class<?> clazz = Class.forName(k.getTarget());
                String methodName = (String)k.getData().get("method");
                List<String> values = (List<String>)k.getData().get("value");
                if (values == null) {
                    values = List.of(v);
                }
                List<ResourceLocation> ids = values.stream().map(s -> KUtil.RL(s, v)).toList();
                for (ResourceLocation id : ids) {
                    LoadingContext context = new LoadingContext(id);
                    try {
                        Boolean bl = (Boolean)MethodUtils.invokeExactStaticMethod(clazz, (String)methodName, (Object[])new Object[]{context});
                        if (bl.booleanValue()) continue;
                        disabledModules.add(id);
                    }
                    catch (Exception e) {
                        disabledModules.add(id);
                        throw e;
                        return;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error(MARKER, "Failed to access to LoadingCondition: %s".formatted(k), (Throwable)e);
            }
        });
        HashMap infos = Maps.newHashMap();
        boolean checkDep = false;
        block2: for (Map.Entry entry : moduleData.entries()) {
            ResourceLocation rl;
            module = (KiwiAnnotationData)entry.getValue();
            String modid = (String)entry.getKey();
            if (!Platform.isModLoaded(modid)) continue;
            Object name = (String)((KiwiAnnotationData)((Object)module)).getData().get("value");
            if (Strings.isNullOrEmpty((String)name)) {
                name = "core";
            }
            if (disabledModules.contains(rl = ResourceLocation.fromNamespaceAndPath((String)modid, (String)name)) || KiwiConfigManager.modules.containsKey(rl) && !KiwiConfigManager.modules.get(rl).get().booleanValue()) continue;
            Info info = new Info(rl, ((KiwiAnnotationData)((Object)module)).getTarget());
            String dependencies = (String)((KiwiAnnotationData)((Object)module)).getData().get("dependencies");
            List<String> rules = Stream.of(Strings.nullToEmpty((String)dependencies).split(";")).filter(s -> !Strings.isNullOrEmpty((String)s)).toList();
            for (String rule : rules) {
                if (rule.startsWith("@")) {
                    info.moduleRules.add(KUtil.RL(rule.substring(1), modid));
                    checkDep = true;
                    continue;
                }
                if (Platform.isModLoaded(rule)) continue;
                continue block2;
            }
            infos.put(rl, info);
        }
        if (checkDep) {
            Iterator<KiwiModuleContainer> errorList = Lists.newLinkedList();
            block4: for (Info i : infos.values()) {
                for (ResourceLocation id : i.moduleRules) {
                    if (infos.containsKey(id)) continue;
                    errorList.add((KiwiModuleContainer)((Object)i));
                    continue block4;
                }
            }
            module = errorList.iterator();
            while (module.hasNext()) {
                Info i;
                i = (Info)module.next();
                String dependencies = StringUtils.join(i.moduleRules, (String)", ");
                ModLoader.addLoadingIssue((ModLoadingIssue)ModLoadingIssue.error((String)"msg.kiwi.no_dependencies", (Object[])new Object[]{i.id, dependencies}));
            }
            if (!errorList.isEmpty()) {
                return;
            }
            MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(infos.size()).build();
            infos.keySet().forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
            infos.values().forEach($ -> $.moduleRules.forEach(r -> graph.putEdge(r, (Object)$.id)));
            moduleLoadingQueue = TopologicalSort.topologicalSort((Graph)graph, null);
        } else {
            moduleLoadingQueue = ImmutableList.copyOf(infos.keySet());
        }
        for (ResourceLocation id : moduleLoadingQueue) {
            block16: {
                Info info = (Info)infos.get(id);
                ModContext context = ModContext.get(id.getNamespace());
                context.setActiveContainer();
                try {
                    KiwiModule.ClientCompanion clientCompanion;
                    Class<?> clazz = Class.forName(info.className);
                    Kiwi.instantiateModule(id, clazz, context);
                    if (!Platform.isPhysicalClient() || (clientCompanion = clazz.getDeclaredAnnotation(KiwiModule.ClientCompanion.class)) == null) break block16;
                    Kiwi.instantiateModule(id.withSuffix("_client"), clientCompanion.value(), context);
                }
                catch (Exception e) {
                    LOGGER.error(MARKER, "Kiwi failed to initialize module class: %s".formatted(info.className), (Throwable)e);
                    continue;
                }
            }
            ModLoadingContext.get().setActiveContainer(null);
        }
        moduleData.clear();
        moduleData = null;
        defaultOptions.clear();
        defaultOptions = null;
        conditions.clear();
        conditions = null;
        KiwiModules.fire(KiwiModuleContainer::addRegistries);
        ModLoadingContext.get().setActiveContainer(null);
        for (KiwiModuleContainer container : KiwiModules.get()) {
            container.loadGameObjects();
        }
        KiwiModules.ALL_USED_REGISTRIES.add(Registries.CREATIVE_MODE_TAB);
        KiwiModules.ALL_USED_REGISTRIES.add(Registries.ITEM);
        KiwiModules.fire(KiwiModuleContainer::addEntries);
        ModLoadingContext.get().setActiveContainer(null);
        ArrayList entries = Lists.newArrayList();
        for (KiwiModuleContainer container : KiwiModules.get()) {
            ResourceLocation uid = Objects.requireNonNull(container.module.uid);
            if (ID.equals(uid.getNamespace()) && uid.getPath().startsWith("contributors")) continue;
            LOGGER.info(MARKER, "Module [{}] initialized", (Object)uid);
            container.registries.registries.asMap().forEach((key, values) -> {
                if (!values.isEmpty()) {
                    entries.add("%s: %s".formatted(KUtil.trimRL(key), values.size()));
                }
            });
            if (entries.isEmpty()) continue;
            LOGGER.info(MARKER, "\t\t" + String.join((CharSequence)", ", entries));
            entries.clear();
        }
        stage = LoadingStage.INITED;
    }

    private static void instantiateModule(ResourceLocation id, Class<?> clazz, ModContext context) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        AbstractModule instance = (AbstractModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        KiwiModules.add(id, instance, context);
    }

    public static void registerRegistry(ResourceKey<? extends Registry<?>> registry, Class<?> baseClass) {
        Objects.requireNonNull(registryLookup);
        Kiwi.registryLookup.registries.put(baseClass, registry);
    }

    private static void registerRegistries() throws Exception {
        Kiwi.registerRegistry(Registries.GAME_EVENT, GameEvent.class);
        Kiwi.registerRegistry(Registries.SOUND_EVENT, SoundEvent.class);
        Kiwi.registerRegistry(Registries.FLUID, Fluid.class);
        Kiwi.registerRegistry(Registries.MOB_EFFECT, MobEffect.class);
        Kiwi.registerRegistry(Registries.BLOCK, Block.class);
        Kiwi.registerRegistry(Registries.ENTITY_TYPE, EntityType.class);
        Kiwi.registerRegistry(Registries.ITEM, Item.class);
        Kiwi.registerRegistry(Registries.POTION, Potion.class);
        Kiwi.registerRegistry(Registries.PARTICLE_TYPE, ParticleType.class);
        Kiwi.registerRegistry(Registries.BLOCK_ENTITY_TYPE, BlockEntityType.class);
        Kiwi.registerRegistry(Registries.PAINTING_VARIANT, PaintingVariant.class);
        Kiwi.registerRegistry(Registries.CHUNK_STATUS, ChunkStatus.class);
        Kiwi.registerRegistry(Registries.RULE_TEST, RuleTestType.class);
        Kiwi.registerRegistry(Registries.POS_RULE_TEST, PosRuleTestType.class);
        Kiwi.registerRegistry(Registries.MENU, MenuType.class);
        Kiwi.registerRegistry(Registries.RECIPE_TYPE, RecipeType.class);
        Kiwi.registerRegistry(Registries.RECIPE_SERIALIZER, RecipeSerializer.class);
        Kiwi.registerRegistry(Registries.ATTRIBUTE, Attribute.class);
        Kiwi.registerRegistry(Registries.POSITION_SOURCE_TYPE, PositionSourceType.class);
        Kiwi.registerRegistry(Registries.COMMAND_ARGUMENT_TYPE, ArgumentTypeInfo.class);
        Kiwi.registerRegistry(Registries.STAT_TYPE, StatType.class);
        Kiwi.registerRegistry(Registries.VILLAGER_TYPE, VillagerType.class);
        Kiwi.registerRegistry(Registries.VILLAGER_PROFESSION, VillagerProfession.class);
        Kiwi.registerRegistry(Registries.POINT_OF_INTEREST_TYPE, PoiType.class);
        Kiwi.registerRegistry(Registries.MEMORY_MODULE_TYPE, MemoryModuleType.class);
        Kiwi.registerRegistry(Registries.SENSOR_TYPE, SensorType.class);
        Kiwi.registerRegistry(Registries.SCHEDULE, Schedule.class);
        Kiwi.registerRegistry(Registries.ACTIVITY, Activity.class);
        Kiwi.registerRegistry(Registries.LOOT_POOL_ENTRY_TYPE, LootPoolEntryType.class);
        Kiwi.registerRegistry(Registries.LOOT_FUNCTION_TYPE, LootItemFunctionType.class);
        Kiwi.registerRegistry(Registries.LOOT_CONDITION_TYPE, LootItemConditionType.class);
        Kiwi.registerRegistry(Registries.LOOT_NUMBER_PROVIDER_TYPE, LootNumberProviderType.class);
        Kiwi.registerRegistry(Registries.LOOT_NBT_PROVIDER_TYPE, LootNbtProviderType.class);
        Kiwi.registerRegistry(Registries.LOOT_SCORE_PROVIDER_TYPE, LootScoreProviderType.class);
        Kiwi.registerRegistry(Registries.FLOAT_PROVIDER_TYPE, FloatProviderType.class);
        Kiwi.registerRegistry(Registries.INT_PROVIDER_TYPE, IntProviderType.class);
        Kiwi.registerRegistry(Registries.HEIGHT_PROVIDER_TYPE, HeightProviderType.class);
        Kiwi.registerRegistry(Registries.BLOCK_PREDICATE_TYPE, BlockPredicateType.class);
        Kiwi.registerRegistry(Registries.CARVER, WorldCarver.class);
        Kiwi.registerRegistry(Registries.FEATURE, Feature.class);
        Kiwi.registerRegistry(Registries.STRUCTURE_PLACEMENT, StructurePlacementType.class);
        Kiwi.registerRegistry(Registries.STRUCTURE_PIECE, StructurePieceType.class);
        Kiwi.registerRegistry(Registries.STRUCTURE_TYPE, StructureType.class);
        Kiwi.registerRegistry(Registries.PLACEMENT_MODIFIER_TYPE, PlacementModifierType.class);
        Kiwi.registerRegistry(Registries.BLOCK_STATE_PROVIDER_TYPE, BlockStateProviderType.class);
        Kiwi.registerRegistry(Registries.FOLIAGE_PLACER_TYPE, FoliagePlacerType.class);
        Kiwi.registerRegistry(Registries.TRUNK_PLACER_TYPE, TrunkPlacerType.class);
        Kiwi.registerRegistry(Registries.ROOT_PLACER_TYPE, RootPlacerType.class);
        Kiwi.registerRegistry(Registries.TREE_DECORATOR_TYPE, TreeDecoratorType.class);
        Kiwi.registerRegistry(Registries.FEATURE_SIZE_TYPE, FeatureSizeType.class);
        Kiwi.registerRegistry(Registries.STRUCTURE_PROCESSOR, StructureProcessorType.class);
        Kiwi.registerRegistry(Registries.STRUCTURE_POOL_ELEMENT, StructurePoolElementType.class);
        Kiwi.registerRegistry(Registries.CAT_VARIANT, CatVariant.class);
        Kiwi.registerRegistry(Registries.FROG_VARIANT, FrogVariant.class);
        Kiwi.registerRegistry(Registries.INSTRUMENT, Instrument.class);
        Kiwi.registerRegistry(Registries.CREATIVE_MODE_TAB, CreativeModeTab.class);
        Kiwi.registerRegistry(Registries.ARMOR_MATERIAL, ArmorMaterial.class);
        Kiwi.registerRegistry(Registries.DATA_COMPONENT_TYPE, DataComponentType.class);
        Kiwi.registerRegistry(Registries.ITEM_SUB_PREDICATE_TYPE, ItemSubPredicate.Type.class);
        Kiwi.registerRegistry(NeoForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, EntityDataSerializer.class);
        Kiwi.registerRegistry(NeoForgeRegistries.Keys.INGREDIENT_TYPES, IngredientType.class);
        Kiwi.registerRegistry(NeoForgeRegistries.Keys.FLUID_INGREDIENT_TYPES, FluidIngredientType.class);
        Kiwi.registerRegistry(NeoForgeRegistries.Keys.ATTACHMENT_TYPES, AttachmentType.class);
    }

    public static void registerTab(String id, ResourceKey<CreativeModeTab> tab) {
        Validate.isTrue((!GROUPS.containsKey(id) ? 1 : 0) != 0, (String)"Already exists: %s", (Object[])new Object[]{id});
        GROUPS.put(id, tab);
    }

    private static void registerTabs() {
        Kiwi.registerTab("building_blocks", (ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS);
        Kiwi.registerTab("colored_blocks", (ResourceKey<CreativeModeTab>)CreativeModeTabs.COLORED_BLOCKS);
        Kiwi.registerTab("combat", (ResourceKey<CreativeModeTab>)CreativeModeTabs.COMBAT);
        Kiwi.registerTab("food_and_drinks", (ResourceKey<CreativeModeTab>)CreativeModeTabs.FOOD_AND_DRINKS);
        Kiwi.registerTab("functional_blocks", (ResourceKey<CreativeModeTab>)CreativeModeTabs.FUNCTIONAL_BLOCKS);
        Kiwi.registerTab("ingredients", (ResourceKey<CreativeModeTab>)CreativeModeTabs.INGREDIENTS);
        Kiwi.registerTab("natural_blocks", (ResourceKey<CreativeModeTab>)CreativeModeTabs.NATURAL_BLOCKS);
        Kiwi.registerTab("op_blocks", (ResourceKey<CreativeModeTab>)CreativeModeTabs.OP_BLOCKS);
        Kiwi.registerTab("redstone_blocks", (ResourceKey<CreativeModeTab>)CreativeModeTabs.REDSTONE_BLOCKS);
        Kiwi.registerTab("spawn_eggs", (ResourceKey<CreativeModeTab>)CreativeModeTabs.SPAWN_EGGS);
        Kiwi.registerTab("tools_and_utilities", (ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES);
    }

    @Nullable
    static ResourceKey<CreativeModeTab> getGroup(String path) {
        return GROUPS.get(path);
    }

    public static boolean isLoaded(ResourceLocation module) {
        return KiwiModules.isLoaded(module);
    }

    public static void enableDataModule() {
        enableDataModule = true;
    }

    private void init(FMLCommonSetupEvent event) {
        KiwiConfigManager.refresh();
        InitEvent e = new InitEvent((ParallelDispatchEvent)event);
        KiwiModules.fire(m -> m.init(e));
        ModLoadingContext.get().setActiveContainer(null);
    }

    private void onCommandsRegister(RegisterCommandsEvent event) {
        KiwiCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void postInit(InterModProcessEvent event) {
        PostInitEvent e = new PostInitEvent((ParallelDispatchEvent)event);
        KiwiModules.fire(m -> m.postInit(e));
        ModLoadingContext.get().setActiveContainer(null);
        KiwiModules.clear();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        Kiwi.registryLookup.cache.invalidateAll();
    }

    private void onAttachEntity(AttackEntityEvent event) {
        KUtil.onAttackEntity(event.getEntity(), event.getEntity().level(), InteractionHand.MAIN_HAND, event.getTarget(), null);
    }

    private static enum LoadingStage {
        UNINITED,
        CONSTRUCTING,
        CONSTRUCTED,
        INITED;

    }

    private static final class Info {
        final ResourceLocation id;
        final String className;
        final List<ResourceLocation> moduleRules = Lists.newLinkedList();

        public Info(ResourceLocation id, String className) {
            this.id = id;
            this.className = className;
        }
    }
}

