/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.customization.block.GlassType;
import snownee.kiwi.customization.block.behavior.SitManager;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.builder.BuildersButton;
import snownee.kiwi.customization.builder.ConvertScreen;
import snownee.kiwi.customization.command.ExportBlocksCommand;
import snownee.kiwi.customization.command.ExportCreativeTabsCommand;
import snownee.kiwi.customization.command.ExportShapesCommand;
import snownee.kiwi.customization.command.PrintFamiliesCommand;
import snownee.kiwi.customization.command.ReloadBlockSettingsCommand;
import snownee.kiwi.customization.command.ReloadFamiliesAndRulesCommand;
import snownee.kiwi.customization.command.ReloadSlotsCommand;
import snownee.kiwi.customization.item.loader.KItemDefinition;
import snownee.kiwi.util.ClientProxy;
import snownee.kiwi.util.client.ColorProviderUtil;
import snownee.kiwi.util.client.SmartKey;

public final class CustomizationClient {
    @Nullable
    public static SmartKey buildersButtonKey;

    public static void init(IEventBus modEventBus) {
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        modEventBus.addListener(event -> {
            buildersButtonKey = new SmartKey.Builder("key.kiwi.builders_button2", "key.categories.gameplay").onLongPress(BuildersButton::onLongPress).onShortPress(BuildersButton::onShortPress).build();
            event.register((KeyMapping)buildersButtonKey);
            ClientProxy.afterRegisterSmartKey(buildersButtonKey);
        });
        forgeEventBus.addListener(event -> ConvertScreen.tickLingering());
        forgeEventBus.addListener(event -> {
            LiteralArgumentBuilder kiwi = Commands.literal((String)"kiwi");
            LiteralArgumentBuilder customization = (LiteralArgumentBuilder)Commands.literal((String)"customization").requires(source -> source.hasPermission(2));
            LiteralArgumentBuilder export = Commands.literal((String)"export");
            ExportBlocksCommand.register((LiteralArgumentBuilder<CommandSourceStack>)export);
            ExportShapesCommand.register((LiteralArgumentBuilder<CommandSourceStack>)export);
            ExportCreativeTabsCommand.register((LiteralArgumentBuilder<CommandSourceStack>)export);
            LiteralArgumentBuilder reload = Commands.literal((String)"reload");
            ReloadSlotsCommand.register((LiteralArgumentBuilder<CommandSourceStack>)reload);
            ReloadBlockSettingsCommand.register((LiteralArgumentBuilder<CommandSourceStack>)reload);
            ReloadFamiliesAndRulesCommand.register((LiteralArgumentBuilder<CommandSourceStack>)reload);
            PrintFamiliesCommand.register((LiteralArgumentBuilder<CommandSourceStack>)customization);
            event.getDispatcher().register((LiteralArgumentBuilder)kiwi.then(((LiteralArgumentBuilder)customization.then((ArgumentBuilder)export)).then((ArgumentBuilder)reload)));
        });
        forgeEventBus.addListener(event -> BuildersButton.renderDebugText(event.getLeft(), event.getRight()));
        forgeEventBus.addListener(event -> {
            if (BuildersButton.cancelRenderHighlight()) {
                event.setCanceled(true);
            }
        });
        forgeEventBus.addListener(event -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && SitManager.isSeatEntity(player.getVehicle())) {
                SitManager.clampRotation((Player)player, player.getVehicle());
            }
        });
    }

    public static void afterRegister(Map<ResourceLocation, KItemDefinition> items, Map<ResourceLocation, KBlockDefinition> blocks, ClientProxy.Context context) {
        ResourceLocation colorProvider;
        HashMap blockColors = Maps.newHashMap();
        HashMap itemColors = Maps.newHashMap();
        ArrayList blocksToAdd = Lists.newArrayList();
        ArrayList itemsToAdd = Lists.newArrayList();
        HashSet addedItems = Sets.newHashSet();
        for (Map.Entry<ResourceLocation, KItemDefinition> entry : items.entrySet()) {
            Item providerItem;
            KItemDefinition definition = entry.getValue();
            if (definition.properties().colorProvider().isEmpty()) continue;
            Item item = (Item)BuiltInRegistries.ITEM.get(entry.getKey());
            colorProvider = definition.properties().colorProvider().get();
            if ("minecraft".equals(colorProvider.getNamespace()) && colorProvider.getPath().equals("grass")) {
                colorProvider = ResourceLocation.withDefaultNamespace((String)"short_grass");
            }
            if ((providerItem = (Item)BuiltInRegistries.ITEM.get(colorProvider)) == Items.AIR) {
                Kiwi.LOGGER.warn("Cannot find color provider item %s for item %s".formatted(colorProvider, entry.getKey()));
                continue;
            }
            itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, ColorProviderUtil::delegate)));
            addedItems.add(item);
        }
        for (Map.Entry<ResourceLocation, Record> entry : blocks.entrySet()) {
            Item item;
            Block providerBlock;
            BlockDefinitionProperties properties = ((KBlockDefinition)entry.getValue()).properties();
            if (context.loading()) {
                RenderLayerEnum renderType = properties.renderType().orElse(null);
                if (renderType == null) {
                    renderType = properties.glassType().map(GlassType::renderType).orElse(null);
                }
                if (renderType != null) {
                    Block block = (Block)BuiltInRegistries.BLOCK.get(entry.getKey());
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)((RenderType)renderType.value));
                }
            }
            if (properties.colorProvider().isEmpty()) continue;
            Block block = (Block)BuiltInRegistries.BLOCK.get(entry.getKey());
            colorProvider = properties.colorProvider().get();
            if ("minecraft".equals(colorProvider.getNamespace()) && colorProvider.getPath().equals("grass")) {
                colorProvider = ResourceLocation.withDefaultNamespace((String)"short_grass");
            }
            if ((providerBlock = (Block)BuiltInRegistries.BLOCK.get(colorProvider)) == Blocks.AIR) {
                Kiwi.LOGGER.warn("Cannot find color provider block %s for block %s".formatted(colorProvider, entry.getKey()));
            } else {
                blocksToAdd.add(Pair.of((Object)block, (Object)blockColors.computeIfAbsent(providerBlock, ColorProviderUtil::delegate)));
            }
            if ((item = block.asItem()) == Items.AIR || addedItems.contains(item)) continue;
            addedItems.add(item);
            Item providerItem = providerBlock.asItem();
            if (providerItem != Items.AIR) {
                itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, ColorProviderUtil::delegate)));
                continue;
            }
            if (providerBlock == Blocks.WATER) {
                itemsToAdd.add(Pair.of((Object)item, (stack, i) -> 4159204));
                continue;
            }
            itemsToAdd.add(Pair.of((Object)item, (Object)itemColors.computeIfAbsent(providerItem, $ -> ColorProviderUtil.delegateItemFallback(providerBlock))));
        }
        ClientProxy.registerColors(context, blocksToAdd, itemsToAdd);
    }
}

