/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import com.mojang.datafixers.types.Type;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.KiwiModuleContainer;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.block.entity.InheritanceBlockEntityType;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.loader.event.PostInitEvent;
import snownee.kiwi.util.KiwiTabBuilder;

public abstract class AbstractModule {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    protected final Map<ResourceKey<? extends Registry<?>>, BiConsumer<KiwiModuleContainer, KiwiGO<?>>> decorators = Maps.newIdentityHashMap();
    @Nullable
    public ResourceLocation uid;

    protected static <T> KiwiGO<T> go(Supplier<? extends T> factory) {
        return new KiwiGO<T>(factory);
    }

    protected static <T> KiwiGO<T> go(Supplier<? extends T> factory, ResourceKey<? extends Registry<?>> registryKey) {
        return new KiwiGO.RegistrySpecified<T>(factory, registryKey);
    }

    protected static <T> KiwiGO<T> ref(ResourceKey<? extends Registry<?>> registryKey) {
        return new KiwiGO.Ref(registryKey);
    }

    protected static Item.Properties itemProp() {
        return new Item.Properties();
    }

    protected static BlockBehaviour.Properties blockProp() {
        return BlockBehaviour.Properties.of();
    }

    protected static BlockBehaviour.Properties blockProp(BlockBehaviour block) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block);
    }

    @SafeVarargs
    public static <T extends BlockEntity> KiwiGO<BlockEntityType<T>> blockEntity(BlockEntityType.BlockEntitySupplier<? extends T> factory, Type<?> datafixer, Supplier<? extends Block> ... blocks) {
        return AbstractModule.go(() -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])Stream.of(blocks).map(Supplier::get).toArray(Block[]::new))).build(datafixer));
    }

    public static <T extends BlockEntity> KiwiGO<BlockEntityType<T>> blockEntity(BlockEntityType.BlockEntitySupplier<? extends T> factory, Type<?> datafixer, Class<? extends Block> blockClass) {
        return AbstractModule.go(() -> new InheritanceBlockEntityType(factory, blockClass, datafixer));
    }

    public static CreativeModeTab.Builder itemCategory(ResourceLocation id, Supplier<ItemStack> icon) {
        return new KiwiTabBuilder(id).icon(icon);
    }

    public static TagKey<Item> itemTag(String namespace, String path) {
        return AbstractModule.tag(Registries.ITEM, namespace, path);
    }

    public static TagKey<EntityType<?>> entityTag(String namespace, String path) {
        return AbstractModule.tag(Registries.ENTITY_TYPE, namespace, path);
    }

    public static TagKey<Block> blockTag(String namespace, String path) {
        return AbstractModule.tag(Registries.BLOCK, namespace, path);
    }

    public static TagKey<Fluid> fluidTag(String namespace, String path) {
        return AbstractModule.tag(Registries.FLUID, namespace, path);
    }

    public static <T> TagKey<T> tag(ResourceKey<? extends Registry<T>> registryKey, String namespace, String path) {
        return TagKey.create(registryKey, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static TagKey<Item> itemTag(String id) {
        return AbstractModule.tag(Registries.ITEM, id);
    }

    public static TagKey<EntityType<?>> entityTag(String id) {
        return AbstractModule.tag(Registries.ENTITY_TYPE, id);
    }

    public static TagKey<Block> blockTag(String id) {
        return AbstractModule.tag(Registries.BLOCK, id);
    }

    public static TagKey<Fluid> fluidTag(String id) {
        return AbstractModule.tag(Registries.FLUID, id);
    }

    public static <T> TagKey<T> tag(ResourceKey<? extends Registry<T>> registryKey, String id) {
        ResourceLocation location;
        if (id.contains(":")) {
            location = ResourceLocation.parse((String)id);
        } else {
            Class callerClass = STACK_WALKER.walk(stream -> stream.map(StackWalker.StackFrame::getDeclaringClass).filter(cls -> cls != AbstractModule.class).findFirst()).orElse(null);
            if (callerClass == null) {
                throw new IllegalStateException("No caller class found");
            }
            KiwiModule annotation = callerClass.getDeclaredAnnotation(KiwiModule.class);
            if (annotation == null || annotation.modId().isEmpty()) {
                throw new IllegalStateException("No KiwiModule modId found on " + callerClass.getName());
            }
            location = ResourceLocation.fromNamespaceAndPath((String)annotation.modId(), (String)id);
        }
        return TagKey.create(registryKey, (ResourceLocation)location);
    }

    public void addRegistries() {
    }

    protected void addEntries() {
    }

    protected void init(InitEvent event) {
    }

    protected void postInit(PostInitEvent event) {
    }

    public ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)Objects.requireNonNull(this.uid).getNamespace(), (String)path);
    }

    public KiwiModuleContainer container() {
        return KiwiModules.get(Objects.requireNonNull(this.uid));
    }
}

