/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.ModContext;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.util.KUtil;

public class GroupSetting {
    private final String[] groups;
    private final String @Nullable [] after;
    private final List<ItemCategoryFiller> fillers = Lists.newArrayList();

    public static GroupSetting of(KiwiModule.Category category, @Nullable GroupSetting preset) {
        if (preset != null) {
            if (category.value().length == 0 && category.after().length == 0) {
                return preset;
            }
            if (category.value().length == 0) {
                return new GroupSetting(preset.groups, category.after());
            }
        }
        return new GroupSetting(category.value(), category.after());
    }

    public GroupSetting(String[] groups, String @Nullable [] after) {
        this.groups = groups;
        this.after = after == null || after.length == 0 ? null : after;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groups", (Object)Arrays.toString(this.groups)).append("after", (Object)Arrays.toString(this.after)).toString();
    }

    public void apply(ItemCategoryFiller filler) {
        this.fillers.add(filler);
    }

    public void postApply() {
        List<ResourceKey> tabKeys = Stream.of(this.groups).map($ -> {
            ResourceKey<CreativeModeTab> tab = Kiwi.getGroup($);
            if (tab != null) {
                return tab;
            }
            return ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)ResourceLocation.parse((String)$));
        }).toList();
        IEventBus eventBus = Objects.requireNonNull(ModContext.get((String)"kiwi").modContainer.getEventBus());
        for (ResourceKey tabKey : tabKeys) {
            eventBus.addListener(event -> {
                if (!event.getTabKey().equals(tabKey)) {
                    return;
                }
                List<Item> afterItems = this.after == null ? List.of() : Stream.of(this.after).map(KUtil::RL).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).filter(Predicate.not(Items.AIR::equals)).toList();
                List<Object> items = Lists.newArrayList();
                for (ItemCategoryFiller filler : this.fillers) {
                    CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(tabKey);
                    if (tab == null) continue;
                    filler.fillItemCategory(tab, event.getFlags(), event.hasPermissions(), items);
                }
                items = GroupSetting.getEnabledStacks(items, event.getFlags());
                GroupSetting.addAfter(items, event, afterItems);
            });
        }
    }

    private static void addAfter(List<ItemStack> toAdd, BuildCreativeModeTabContentsEvent event, Collection<Item> afterItems) {
        ObjectSortedSet parentEntries = event.getParentEntries();
        ItemStack lastFound = ItemStack.EMPTY;
        for (Item item : afterItems) {
            ItemStack stack = new ItemStack((ItemLike)item);
            if (!parentEntries.contains((Object)stack)) continue;
            lastFound = stack;
        }
        ItemStack prev = ItemStack.EMPTY;
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack item = toAdd.get(i);
            if (i == 0) {
                if (lastFound.isEmpty()) {
                    event.accept(item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                } else {
                    event.insertAfter(lastFound, item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            } else {
                event.insertAfter(prev, item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
            prev = item;
        }
    }

    private static List<ItemStack> getEnabledStacks(List<ItemStack> newStacks, FeatureFlagSet enabledFeatures) {
        if (newStacks.stream().allMatch($ -> GroupSetting.isEnabled($, enabledFeatures))) {
            return newStacks;
        }
        return newStacks.stream().filter($ -> GroupSetting.isEnabled($, enabledFeatures)).toList();
    }

    private static boolean isEnabled(ItemStack stack, FeatureFlagSet enabledFeatures) {
        return stack.getItem().isEnabled(enabledFeatures);
    }
}

