/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.block.entity.BlockEntityDataListener;

public abstract class ModBlockEntity
extends BlockEntity
implements BlockEntityDataListener {
    public boolean persistData = false;

    public ModBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.readPacketData(pkt.getTag());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.writePacketData(new CompoundTag(), provider);
    }

    protected abstract void readPacketData(CompoundTag var1);

    protected abstract CompoundTag writePacketData(CompoundTag var1, HolderLookup.Provider var2);

    public void refresh() {
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 11);
            this.setChanged();
        }
    }
}

