/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import java.util.List;
import java.util.Objects;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import snownee.kiwi.config.ClothConfigIntegration;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfigManager;

public class NeoClothConfigIntegration {
    public static void init() {
        List<String> mods = KiwiConfigManager.allConfigs.stream().map(ConfigHandler::getModId).distinct().toList();
        IConfigScreenFactory factory = (container, screen) -> Objects.requireNonNull(ClothConfigIntegration.create(screen, container.getModId()));
        for (String mod : mods) {
            List<ConfigHandler> configs = KiwiConfigManager.getModHandlersWithScreen(mod, ClothConfigIntegration.attributes());
            if (configs.isEmpty()) continue;
            ModList.get().getModContainerById(mod).ifPresent($ -> $.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)factory));
        }
    }
}

