/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.client.gui;

import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.contributor.Contributors;
import snownee.kiwi.contributor.ContributorsClient;

public class CosmeticScreen
extends Screen {
    private List list;
    @Nullable
    private ResourceLocation currentCosmetic;
    private Entry selectedEntry;

    public CosmeticScreen() {
        super((Component)Component.translatable((String)"gui.kiwi.cosmetic"));
    }

    private static String getPlayerName() {
        return Minecraft.getInstance().getUser().getName();
    }

    protected void init() {
        this.currentCosmetic = Contributors.PLAYER_COSMETICS.get(CosmeticScreen.getPlayerName());
        this.list = new List(this.getMinecraft(), 150, this.height, 0, 20);
        this.list.setX(20);
        this.selectedEntry = new Entry(this, null);
        this.list.addEntry(this.selectedEntry);
        String playerName = CosmeticScreen.getPlayerName();
        boolean added = false;
        for (ResourceLocation tier : Contributors.getRenderableTiers()) {
            if (!Contributors.isContributor(tier.getNamespace(), playerName, tier.getPath())) continue;
            Entry entry = new Entry(this, tier);
            this.list.addEntry(entry);
            added = true;
            if (!tier.equals((Object)this.currentCosmetic)) continue;
            this.selectedEntry = entry;
        }
        if (!added) {
            this.getMinecraft().setScreen(null);
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)(KiwiClientConfig.cosmeticScreenKeybind ? "gui.kiwi.cosmetic.enabled" : "gui.kiwi.cosmetic.disabled")), b -> {
            KiwiClientConfig.cosmeticScreenKeybind = !KiwiClientConfig.cosmeticScreenKeybind;
            KiwiConfigManager.getHandler(KiwiClientConfig.class).save();
            b.setMessage((Component)Component.translatable((String)(KiwiClientConfig.cosmeticScreenKeybind ? "gui.kiwi.cosmetic.enabled" : "gui.kiwi.cosmetic.disabled")));
        }).pos(180, 30).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float pTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, pTicks);
        super.render(guiGraphics, mouseX, mouseY, pTicks);
        this.list.render(guiGraphics, mouseX, mouseY, pTicks);
        guiGraphics.drawString(this.getMinecraft().font, this.title, 180, 10, 0xFFFFFF);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.list.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.list.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.list.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        this.list.mouseScrolled(d, e, f, g);
        return super.mouseScrolled(d, e, f, g);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        this.list.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void onClose() {
        super.onClose();
        this.list = null;
        ConfigHandler cfg = KiwiConfigManager.getHandler(KiwiClientConfig.class);
        if (this.currentCosmetic != null && this.selectedEntry.id == null) {
            KiwiClientConfig.contributorCosmetic = "";
            cfg.save();
            ContributorsClient.changeCosmetic();
        } else if (this.selectedEntry != null && !Objects.equals(this.selectedEntry.id, this.currentCosmetic)) {
            KiwiClientConfig.contributorCosmetic = this.selectedEntry.id.toString();
            cfg.save();
            ContributorsClient.changeCosmetic();
        }
    }

    private static class List
    extends ObjectSelectionList<Entry> {
        public List(Minecraft mcIn, int widthIn, int heightIn, int topIn, int slotHeightIn) {
            super(mcIn, widthIn, heightIn, topIn, slotHeightIn);
        }

        public int addEntry(Entry p_93487_) {
            return super.addEntry((AbstractSelectionList.Entry)p_93487_);
        }
    }

    private static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final CosmeticScreen parent;
        @Nullable
        private final ResourceLocation id;
        private final String name;

        public Entry(CosmeticScreen parent, @Nullable ResourceLocation id) {
            this.parent = parent;
            this.id = id;
            this.name = id == null ? "-" : I18n.get((String)Util.makeDescriptionId((String)"cosmetic", (ResourceLocation)id), (Object[])new Object[0]);
        }

        public void render(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hover, float partialTicks) {
            int color;
            int n = color = hover ? 0xFFFFAA : 0xFFFFFF;
            if (this == this.parent.selectedEntry) {
                color = 0xFFFF77;
            }
            guiGraphics.drawString(this.parent.font, this.name, left + 43, top + 2, color);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.selectedEntry = this;
            return false;
        }

        public Component getNarration() {
            return Component.translatable((String)this.name);
        }
    }
}

