/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.behavior;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public interface CanSurviveHandler {
    public boolean isSensitiveSide(BlockState var1, Direction var2);

    public boolean canSurvive(BlockState var1, LevelReader var2, BlockPos var3);

    public static CanSurviveHandler checkFloor() {
        return Impls.CHECK_FLOOR;
    }

    public static CanSurviveHandler checkCeiling() {
        return Impls.CHECK_CEILING;
    }

    public static CanSurviveHandler checkFace(DirectionProperty property) {
        return Impls.CHECK_FACE.computeIfAbsent(property, key -> new CanSurviveHandler((DirectionProperty)key){
            final /* synthetic */ DirectionProperty val$key;
            {
                this.val$key = directionProperty;
            }

            @Override
            public boolean isSensitiveSide(BlockState state, Direction side) {
                return side == ((Direction)state.getValue((Property)this.val$key)).getOpposite();
            }

            @Override
            public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
                Direction direction = (Direction)state.getValue((Property)this.val$key);
                BlockPos neighbor = pos.relative(direction);
                return world.getBlockState(neighbor).isFaceSturdy((BlockGetter)world, neighbor, direction.getOpposite(), SupportType.RIGID);
            }
        });
    }

    public static Compound any(List<CanSurviveHandler> handlers) {
        return new Compound(true, handlers);
    }

    public static Compound all(List<CanSurviveHandler> handlers) {
        return new Compound(false, handlers);
    }

    public static final class Impls {
        private static final CanSurviveHandler CHECK_FLOOR = new CanSurviveHandler(){

            @Override
            public boolean isSensitiveSide(BlockState state, Direction side) {
                return side == Direction.DOWN;
            }

            @Override
            public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
                return Block.canSupportRigidBlock((BlockGetter)world, (BlockPos)pos.below());
            }
        };
        private static final CanSurviveHandler CHECK_CEILING = new CanSurviveHandler(){

            @Override
            public boolean isSensitiveSide(BlockState state, Direction side) {
                return side == Direction.UP;
            }

            @Override
            public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
                pos = pos.above();
                return world.getBlockState(pos).isFaceSturdy((BlockGetter)world, pos, Direction.DOWN, SupportType.RIGID);
            }
        };
        private static final Map<DirectionProperty, CanSurviveHandler> CHECK_FACE = Maps.newHashMap();

        private Impls() {
        }
    }

    public record Compound(boolean any, List<CanSurviveHandler> handlers) implements CanSurviveHandler
    {
        @Override
        public boolean isSensitiveSide(BlockState state, Direction side) {
            for (CanSurviveHandler handler : this.handlers) {
                if (!handler.isSensitiveSide(state, side)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
            for (CanSurviveHandler handler : this.handlers) {
                if (handler.canSurvive(state, world, pos) != this.any) continue;
                return this.any;
            }
            return !this.any;
        }
    }
}

