/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.StringProperty;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.util.codec.KCodecs;

public record SimplePropertiesComponent(boolean useShapeForLightOcclusion, List<Pair<Property<?>, String>> properties) implements KBlockComponent
{
    private static final Interner<SimplePropertiesComponent> INTERNER = Interners.newStrongInterner();
    public static final Codec<Pair<Property<?>, String>> SINGLE_CODEC = new Codec<Pair<Property<?>, String>>(){
        private static final Map<String, Direction> DIRECTION_STRINGS = Direction.stream().collect(Collectors.toUnmodifiableMap(StringRepresentable::getSerializedName, Function.identity()));

        public <T> DataResult<Pair<Pair<Property<?>, String>, T>> decode(DynamicOps<T> ops, T input) {
            String defaultString;
            Object property;
            DataResult mapValue = ops.getMap(input);
            if (mapValue.error().isPresent()) {
                return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)mapValue.error().get())).message());
            }
            MapLike map = (MapLike)mapValue.result().orElseThrow();
            DataResult commonValue = ops.getStringValue(map.get("common"));
            Object defaultValue = ops.convertTo((DynamicOps)JavaOps.INSTANCE, map.get("default"));
            List values = Codec.STRING.listOf().parse(ops, map.get("values")).result().orElse(null);
            if (values != null && values.size() < 2) {
                return DataResult.error(() -> "Invalid values for property: " + String.valueOf(values));
            }
            if (defaultValue == null) {
                if (values == null) {
                    return DataResult.error(() -> "Missing default value for property");
                }
                defaultValue = values.get(0);
            }
            if (commonValue.result().isPresent()) {
                String s = (String)commonValue.result().get();
                property = (Property)KBlockUtils.COMMON_PROPERTIES.get((Object)s);
                if (property == null) {
                    return DataResult.error(() -> "Unknown common property: " + s);
                }
            } else {
                String name = (String)ops.getStringValue(map.get("name")).getOrThrow($ -> new IllegalStateException("Missing name for property"));
                if (defaultValue instanceof Integer) {
                    int min = ((Number)ops.getNumberValue(map.get("min")).getOrThrow($ -> new IllegalStateException("Missing min for integer property"))).intValue();
                    int max = ((Number)ops.getNumberValue(map.get("max")).getOrThrow($ -> new IllegalStateException("Missing max for integer property"))).intValue();
                    property = IntegerProperty.create((String)name, (int)min, (int)max);
                } else if (defaultValue instanceof Boolean) {
                    property = BooleanProperty.create((String)name);
                } else if (values != null && defaultValue instanceof String) {
                    String s = (String)defaultValue;
                    property = DIRECTION_STRINGS.containsKey(s) && DIRECTION_STRINGS.keySet().containsAll(values) ? (values.size() == DIRECTION_STRINGS.size() ? DirectionProperty.create((String)name) : DirectionProperty.create((String)name, (Direction[])((Direction[])values.stream().map(DIRECTION_STRINGS::get).toArray(Direction[]::new)))) : new StringProperty(name, values);
                } else {
                    String msg = "Unsupported default value type: " + String.valueOf(defaultValue.getClass());
                    return DataResult.error(() -> msg);
                }
                property = KBlockUtils.internProperty(property);
            }
            try {
                defaultString = KBlockUtils.getNameByValue(property, defaultValue);
                Preconditions.checkArgument((boolean)property.getValue(defaultString).isPresent());
            }
            catch (Exception e) {
                return DataResult.error(() -> "Invalid default value for property: " + e.getMessage());
            }
            return DataResult.success((Object)Pair.of((Object)Pair.of((Object)property, (Object)defaultString), (Object)ops.empty()));
        }

        public <T> DataResult<T> encode(Pair<Property<?>, String> input, DynamicOps<T> ops, T prefix) {
            Object defaultValue;
            RecordBuilder mapBuilder = ops.mapBuilder();
            Property property = (Property)input.getFirst();
            String s = (String)KBlockUtils.COMMON_PROPERTIES.inverse().get((Object)property);
            List values = List.of();
            if (s == null) {
                mapBuilder.add("name", ops.createString(property.getName()));
                if (property instanceof IntegerProperty) {
                    IntegerProperty integerProperty = (IntegerProperty)property;
                    mapBuilder.add("min", ops.createInt(integerProperty.min));
                    mapBuilder.add("max", ops.createInt(integerProperty.max));
                } else if (property instanceof EnumProperty || property instanceof StringProperty) {
                    values = property.getPossibleValues().stream().map($ -> KBlockUtils.getNameByValue(property, $)).collect(Collectors.toCollection(ArrayList::new));
                } else if (!(property instanceof BooleanProperty)) {
                    return DataResult.error(() -> "Unsupported property type: " + String.valueOf(property));
                }
            } else {
                mapBuilder.add("common", ops.createString(s));
            }
            if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                defaultValue = integerProperty.getValue((String)input.getSecond()).map(arg_0 -> ops.createInt(arg_0)).orElse(null);
            } else if (property instanceof BooleanProperty) {
                BooleanProperty booleanProperty = (BooleanProperty)property;
                defaultValue = booleanProperty.getValue((String)input.getSecond()).map(arg_0 -> ops.createBoolean(arg_0)).orElse(null);
            } else {
                Object object = defaultValue = property.getValue((String)input.getSecond()).isPresent() ? ops.createString((String)input.getSecond()) : null;
            }
            if (defaultValue == null) {
                return DataResult.error(() -> "Invalid value %s for property %s".formatted(input.getSecond(), property.getName()));
            }
            if (!values.isEmpty()) {
                values.remove(input.getSecond());
                values.add(0, (String)input.getSecond());
                mapBuilder.add("values", ops.createList(values.stream().map(arg_0 -> ops.createString(arg_0))));
            } else {
                mapBuilder.add("default", defaultValue);
            }
            return mapBuilder.build(prefix);
        }
    };
    public static final MapCodec<SimplePropertiesComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("shape_for_light_occlusion", (Object)false).forGetter(SimplePropertiesComponent::useShapeForLightOcclusion), (App)ExtraCodecs.nonEmptyList(KCodecs.compactList(SINGLE_CODEC)).fieldOf("properties").forGetter(SimplePropertiesComponent::properties)).apply((Applicative)instance, ($1, $2) -> (SimplePropertiesComponent)INTERNER.intern((Object)new SimplePropertiesComponent((boolean)$1, (List<Pair<Property<?>, String>>)$2))));

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.SIMPLE_PROPERTIES.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        for (Pair<Property<?>, String> pair : this.properties) {
            builder.add(new Property[]{(Property)pair.getFirst()});
        }
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        for (Pair<Property<?>, String> pair : this.properties) {
            state = KBlockUtils.setValueByString(state, ((Property)pair.getFirst()).getName(), (String)pair.getSecond());
        }
        return state;
    }

    @Override
    public boolean useShapeForLightOcclusion(BlockState pState) {
        return this.useShapeForLightOcclusion;
    }
}

