/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.item;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.item.ItemCategoryFiller;
import snownee.kiwi.item.ModItem;
import snownee.kiwi.loader.Platform;

public class ModBlockItem
extends BlockItem
implements ItemCategoryFiller {
    public static final Set<BlockEntityType<?>> INSTANT_UPDATE_TILES = Platform.isPhysicalClient() ? Sets.newHashSet() : null;

    public ModBlockItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        CustomData data;
        BlockEntity tile;
        if (worldIn.isClientSide && (tile = worldIn.getBlockEntity(pos)) != null && INSTANT_UPDATE_TILES.contains(tile.getType()) && !(data = (CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).isEmpty()) {
            tile.loadWithComponents(data.copyTag(), (HolderLookup.Provider)worldIn.registryAccess());
            tile.setChanged();
        }
        return super.updateCustomBlockEntityTag(pos, worldIn, player, stack, state);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, tooltip, tooltipFlag);
        if (Platform.isPhysicalClient() && !KiwiClientConfig.globalTooltip) {
            ModItem.addTip(itemStack, tooltip, tooltipFlag);
        }
    }

    public Component getName(ItemStack pStack) {
        Block block = this.getBlock();
        if (block instanceof IKiwiBlock) {
            return ((IKiwiBlock)block).getName(pStack);
        }
        return super.getName(pStack);
    }

    @Override
    public void fillItemCategory(CreativeModeTab tab, FeatureFlagSet flags, boolean hasPermissions, List<ItemStack> items) {
        Block block = this.getBlock();
        if (block instanceof ItemCategoryFiller) {
            ItemCategoryFiller filler = (ItemCategoryFiller)block;
            filler.fillItemCategory(tab, flags, hasPermissions, items);
        } else {
            items.add(new ItemStack((ItemLike)this));
        }
    }
}

