/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import net.minecraft.util.Mth;

public class LerpedFloat {
    protected Interpolator interpolator;
    protected float previousValue;
    protected float value;
    protected Chaser chaseFunction;
    protected float chaseTarget;
    protected float chaseSpeed;
    protected boolean forcedSync;

    public LerpedFloat(Interpolator interpolator) {
        this.interpolator = interpolator;
        this.startWithValue(0.0);
        this.forcedSync = true;
    }

    public static LerpedFloat linear() {
        return new LerpedFloat((p, c, t) -> (float)Mth.lerp((double)p, (double)c, (double)t));
    }

    public LerpedFloat startWithValue(double value) {
        float f;
        this.previousValue = f = (float)value;
        this.chaseTarget = f;
        this.value = f;
        return this;
    }

    public LerpedFloat chase(double value, double speed, Chaser chaseFunction) {
        this.updateChaseTarget((float)value);
        this.chaseSpeed = (float)speed;
        this.chaseFunction = chaseFunction;
        return this;
    }

    public void updateChaseTarget(float target) {
        this.chaseTarget = target;
    }

    public boolean updateChaseSpeed(double speed) {
        float prevSpeed = this.chaseSpeed;
        this.chaseSpeed = (float)speed;
        return !Mth.equal((double)prevSpeed, (double)speed);
    }

    public void tickChaser() {
        this.previousValue = this.value;
        if (this.chaseFunction == null) {
            return;
        }
        if (Mth.equal((double)this.value, (double)this.chaseTarget)) {
            this.value = this.chaseTarget;
            return;
        }
        this.value = this.chaseFunction.chase(this.value, this.chaseSpeed, this.chaseTarget);
    }

    public void setValueNoUpdate(double value) {
        this.value = (float)value;
    }

    public void setValue(double value) {
        this.previousValue = this.value;
        this.value = (float)value;
    }

    public float getValue() {
        return this.getValue(1.0f);
    }

    public float getValue(float partialTicks) {
        return this.interpolator.interpolate(partialTicks, this.previousValue, this.value);
    }

    public boolean settled() {
        return Mth.equal((double)this.previousValue, (double)this.value) && (this.chaseFunction == null || Mth.equal((double)this.value, (double)this.chaseTarget));
    }

    public float getChaseTarget() {
        return this.chaseTarget;
    }

    public void forceNextSync() {
        this.forcedSync = true;
    }

    @FunctionalInterface
    public static interface Interpolator {
        public float interpolate(double var1, double var3, double var5);
    }

    @FunctionalInterface
    public static interface Chaser {
        public static final Chaser IDLE = (c, s, t) -> (float)c;
        public static final Chaser EXP = Chaser.exp(Double.MAX_VALUE);
        public static final Chaser LINEAR = (c, s, t) -> (float)(c + Mth.clamp((double)(t - c), (double)(-s), (double)s));

        public static Chaser exp(double maxEffectiveSpeed) {
            return (c, s, t) -> (float)(c + Mth.clamp((double)((t - c) * s), (double)(-maxEffectiveSpeed), (double)maxEffectiveSpeed));
        }

        public float chase(double var1, double var3, double var5);
    }
}

