/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class NBTHelper {
    @Nullable
    private CompoundTag tag;
    @Nullable
    private final ItemStack stack;
    @Nullable
    private final DataComponentType<CustomData> componentType;

    private NBTHelper(@Nullable CompoundTag tag, @Nullable ItemStack stack, @Nullable DataComponentType<CustomData> componentType) {
        this.tag = tag;
        this.stack = stack;
        this.componentType = componentType;
    }

    @Nullable
    public CompoundTag getTag(String key) {
        return this.getTag(key, false);
    }

    @Nullable
    @Contract(value="_, true -> !null")
    public CompoundTag getTag(String key, boolean createIfNull) {
        return this.getTagInternal(key, createIfNull, false);
    }

    @Nullable
    @Contract(value="_, true, _ -> !null")
    private CompoundTag getTagInternal(String key, boolean createIfNull, boolean ignoreLastNode) {
        if (this.tag == null) {
            if (createIfNull) {
                this.tag = new CompoundTag();
            } else {
                return null;
            }
        }
        if (key.isEmpty()) {
            return this.tag;
        }
        CompoundTag subTag = this.tag;
        String[] parts = key.split("\\.");
        int length = parts.length;
        if (ignoreLastNode) {
            --length;
        }
        for (int i = 0; i < length; ++i) {
            if (!subTag.contains(parts[i], 10)) {
                if (createIfNull) {
                    subTag.put(parts[i], (Tag)new CompoundTag());
                } else {
                    return null;
                }
            }
            subTag = (CompoundTag)Objects.requireNonNull(subTag.get(parts[i]));
        }
        return subTag;
    }

    private CompoundTag getTagInternal(String key) {
        return this.getTagInternal(key, true, true);
    }

    private String getLastNode(String key) {
        int index = key.lastIndexOf(".");
        if (index < 0) {
            return key;
        }
        return key.substring(index + 1);
    }

    public NBTHelper setTag(String key, Tag value) {
        this.getTagInternal(key).put(this.getLastNode(key), value);
        return this;
    }

    public NBTHelper setInt(String key, int value) {
        this.getTagInternal(key).putInt(this.getLastNode(key), value);
        return this;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 3)) {
            return subTag.getInt(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setLong(String key, long value) {
        this.getTagInternal(key).putLong(this.getLastNode(key), value);
        return this;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 4)) {
            return subTag.getLong(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setShort(String key, short value) {
        this.getTagInternal(key).putShort(this.getLastNode(key), value);
        return this;
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 2)) {
            return subTag.getShort(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setDouble(String key, double value) {
        this.getTagInternal(key).putDouble(this.getLastNode(key), value);
        return this;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 6)) {
            return subTag.getDouble(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setFloat(String key, float value) {
        this.getTagInternal(key).putFloat(this.getLastNode(key), value);
        return this;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 5)) {
            return subTag.getFloat(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setByte(String key, byte value) {
        this.getTagInternal(key).putFloat(this.getLastNode(key), (float)value);
        return this;
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 1)) {
            return subTag.getByte(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setBoolean(String key, boolean value) {
        this.getTagInternal(key).putBoolean(this.getLastNode(key), value);
        return this;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 1)) {
            return subTag.getBoolean(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setPos(String key, BlockPos value) {
        this.getTagInternal(key).put(this.getLastNode(key), NbtUtils.writeBlockPos((BlockPos)value));
        return this;
    }

    @Nullable
    public BlockPos getPos(String key) {
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            String actualKey = this.getLastNode(key);
            return NbtUtils.readBlockPos((CompoundTag)subTag, (String)actualKey).orElse(null);
        }
        return null;
    }

    public NBTHelper setBlockState(String key, BlockState value) {
        return this.setTag(key, (Tag)NbtUtils.writeBlockState((BlockState)value));
    }

    public BlockState getBlockState(String key) {
        CompoundTag subTag = this.getTagInternal(key, false, false);
        if (subTag != null) {
            return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)subTag);
        }
        return Blocks.AIR.defaultBlockState();
    }

    public NBTHelper setString(String key, String value) {
        this.getTagInternal(key).putString(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public String getString(String key, @Nullable String defaultValue) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 8)) {
            return subTag.getString(actualKey);
        }
        return defaultValue;
    }

    public NBTHelper setIntArray(String key, int[] value) {
        this.getTagInternal(key).putIntArray(this.getLastNode(key), value);
        return this;
    }

    public int[] getIntArray(String key) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 11)) {
            return subTag.getIntArray(actualKey);
        }
        return new int[0];
    }

    public NBTHelper setByteArray(String key, byte[] value) {
        this.getTagInternal(key).putByteArray(this.getLastNode(key), value);
        return this;
    }

    public byte[] getByteArray(String key) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 7)) {
            return subTag.getByteArray(actualKey);
        }
        return new byte[0];
    }

    public NBTHelper setUUID(String key, UUID value) {
        this.getTagInternal(key).putUUID(this.getLastNode(key), value);
        return this;
    }

    @Nullable
    public UUID getUUID(String key) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.hasUUID(actualKey = this.getLastNode(key))) {
            return subTag.getUUID(actualKey);
        }
        return null;
    }

    @Nullable
    public ListTag getTagList(String key, int type) {
        String actualKey;
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null && subTag.contains(actualKey = this.getLastNode(key), 9)) {
            return subTag.getList(actualKey, type);
        }
        return null;
    }

    public boolean hasTag(String key, int type) {
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            if (key.isEmpty()) {
                return true;
            }
            String actualKey = this.getLastNode(key);
            return subTag.contains(actualKey, type);
        }
        return false;
    }

    public Set<String> keySet(String key) {
        return this.hasTag(key, 10) ? Objects.requireNonNull(this.getTag(key)).getAllKeys() : Set.of();
    }

    public NBTHelper remove(String key) {
        CompoundTag subTag = this.getTagInternal(key, false, true);
        if (subTag != null) {
            String actualKey = this.getLastNode(key);
            subTag.remove(actualKey);
        }
        return this;
    }

    @Nullable
    public CompoundTag get() {
        return this.tag;
    }

    public ItemStack getItem() {
        return this.stack == null ? ItemStack.EMPTY : this.stack;
    }

    public NBTHelper updateItemData() {
        Preconditions.checkNotNull((Object)this.stack);
        Preconditions.checkNotNull(this.componentType);
        if (this.tag == null) {
            this.stack.remove(this.componentType);
        } else {
            CustomData.set(this.componentType, (ItemStack)this.stack, (CompoundTag)this.tag);
        }
        return this;
    }

    public static NBTHelper of(ItemStack stack, DataComponentType<CustomData> componentType) {
        Preconditions.checkState((!stack.isEmpty() ? 1 : 0) != 0);
        return new NBTHelper(((CustomData)stack.getOrDefault(componentType, (Object)CustomData.EMPTY)).copyTag(), stack, componentType);
    }

    public static NBTHelper of(CompoundTag tag) {
        return new NBTHelper(tag, null, null);
    }

    public static NBTHelper create() {
        return NBTHelper.of(new CompoundTag());
    }
}

