/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block.def;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.loader.Platform;

public class SimpleBlockDefinition
implements BlockDefinition {
    private static final MethodHandle GET_STATE_FOR_PLACEMENT;
    public static final String TYPE = "Block";
    private static final Map<BlockState, SimpleBlockDefinition> MAP;
    public final BlockState state;
    @OnlyIn(value=Dist.CLIENT)
    private Material[] materials;

    @Nullable
    private static BlockState getStateForPlacement(BlockItem blockItem, BlockPlaceContext context) {
        try {
            return GET_STATE_FOR_PLACEMENT.invokeExact(blockItem, context);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static SimpleBlockDefinition of(BlockState state) {
        if (state.m_60734_() == Blocks.f_50440_) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(false));
        }
        return MAP.computeIfAbsent(state, SimpleBlockDefinition::new);
    }

    private SimpleBlockDefinition(BlockState state) {
        this.state = state;
        if (Platform.isPhysicalClient()) {
            this.materials = new Material[7];
        }
    }

    @Override
    public BlockDefinition.Factory<?> getFactory() {
        return Factory.INSTANCE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BakedModel model() {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(this.state);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Material renderMaterial(Direction direction) {
        int index;
        int n = index = direction == null ? 0 : direction.ordinal() + 1;
        if (this.materials[index] == null) {
            ResourceLocation particleIcon;
            BakedModel model = this.model();
            RandomSource random = RandomSource.m_216327_();
            random.m_188584_(42L);
            ResourceLocation sprite = particleIcon = model.getParticleIcon(ModelData.EMPTY).m_245424_().m_246162_();
            if (this.state.m_60734_() == Blocks.f_50440_) {
                direction = Direction.UP;
            }
            if (direction != null) {
                BakedQuad quad;
                List quads = model.getQuads(this.state, direction, random, ModelData.EMPTY, null);
                if (quads.isEmpty()) {
                    quads = model.getQuads(this.state, null, random, ModelData.EMPTY, null);
                }
                Iterator iterator = quads.iterator();
                while (iterator.hasNext() && !(sprite = (quad = (BakedQuad)iterator.next()).m_173410_().m_245424_().m_246162_()).equals((Object)particleIcon)) {
                }
            }
            this.materials[index] = new Material(InventoryMenu.f_39692_, sprite);
        }
        return this.materials[index];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ChunkRenderTypeSet getRenderTypes() {
        return this.model().getRenderTypes(this.state, RandomSource.m_216335_((long)42L), this.modelData());
    }

    @Override
    public boolean canOcclude() {
        return this.state.m_60815_();
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128365_(TYPE, (Tag)NbtUtils.m_129202_((BlockState)this.state));
    }

    public String toString() {
        return this.state.toString();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(BlockState blockState, BlockAndTintGetter level, BlockPos worldPosition, int index) {
        return Minecraft.m_91087_().m_91298_().m_92577_(this.state, level, worldPosition, index);
    }

    @Override
    public Component getDescription() {
        return this.state.m_60734_().m_49954_();
    }

    @Override
    public void place(Level level, BlockPos pos) {
        BlockState state = this.state;
        if (state.m_61138_((Property)BlockStateProperties.f_61443_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
        }
        level.m_46597_(pos, state);
    }

    @Override
    public ItemStack createItem(HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getBlockState().getCloneItemStack(target, world, pos, player);
    }

    @Override
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    public SoundType getSoundType() {
        return this.state.m_60827_();
    }

    public static void reload() {
        for (SimpleBlockDefinition supplier : MAP.values()) {
            Arrays.fill(supplier.materials, null);
        }
    }

    static {
        MethodHandle m = null;
        try {
            m = MethodHandles.lookup().unreflect(ObfuscationReflectionHelper.findMethod(BlockItem.class, (String)"m_5965_", (Class[])new Class[]{BlockPlaceContext.class}));
        }
        catch (Exception e) {
            throw new RuntimeException("Report this to author", e);
        }
        GET_STATE_FOR_PLACEMENT = m;
        MAP = Maps.newIdentityHashMap();
    }

    public static enum Factory implements BlockDefinition.Factory<SimpleBlockDefinition>
    {
        INSTANCE;


        @Override
        public SimpleBlockDefinition fromNBT(CompoundTag tag) {
            BlockState state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_(SimpleBlockDefinition.TYPE));
            if (state.m_60795_()) {
                return null;
            }
            return SimpleBlockDefinition.of(state);
        }

        @Override
        public SimpleBlockDefinition fromBlock(BlockState state, BlockEntity blockEntity, LevelReader level, BlockPos pos) {
            return SimpleBlockDefinition.of(state);
        }

        @Override
        public SimpleBlockDefinition fromItem(ItemStack stack, BlockPlaceContext context) {
            if (!(stack.m_41720_() instanceof BlockItem)) {
                return null;
            }
            BlockItem blockItem = (BlockItem)stack.m_41720_();
            if (context == null) {
                return SimpleBlockDefinition.of(blockItem.m_40614_().m_49966_());
            }
            if ((context = blockItem.m_7732_(context)) == null) {
                return null;
            }
            BlockState state = SimpleBlockDefinition.getStateForPlacement(blockItem, context);
            if (state == null) {
                return null;
            }
            return SimpleBlockDefinition.of(state);
        }

        @Override
        public String getId() {
            return SimpleBlockDefinition.TYPE;
        }
    }
}

