/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client.model;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.BlockGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.entity.RetextureBlockEntity;
import snownee.kiwi.util.NBTHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class RetextureModel
implements IDynamicBakedModel {
    public static ModelProperty<Map<String, BlockDefinition>> TEXTURES = new ModelProperty();
    private final ModelBaker baker;
    private final ModelState variant;
    private final ResourceLocation modelLocation;
    private ItemOverrides overrideList;
    private final Cache<String, BakedModel> baked = CacheBuilder.newBuilder().expireAfterAccess(500L, TimeUnit.SECONDS).build();
    private final BlockGeometryBakingContext baseConfiguration;
    private final String particleKey;

    public RetextureModel(ModelBaker baker, ModelState variant, ResourceLocation modelLocation, BlockGeometryBakingContext baseConfiguration, String particleKey, boolean inventory) {
        this.baker = baker;
        this.variant = variant;
        this.modelLocation = modelLocation;
        this.baseConfiguration = baseConfiguration;
        this.overrideList = inventory ? new Overrides(this) : ItemOverrides.f_111734_;
        this.particleKey = particleKey;
    }

    public boolean m_7541_() {
        return this.baseConfiguration.useAmbientOcclusion();
    }

    public boolean m_7539_() {
        return this.baseConfiguration.isGui3d();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        BlockDefinition supplier;
        if (data.get(TEXTURES) != null && (supplier = (BlockDefinition)((Map)data.get(TEXTURES)).get(this.particleKey)) != null) {
            Material material = supplier.renderMaterial(null);
            return (TextureAtlasSprite)this.baker.getModelTextureGetter().apply(material);
        }
        return this.m_6160_();
    }

    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)this.baker.getModelTextureGetter().apply(this.baseConfiguration.getMaterial("particle"));
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public ItemTransforms m_7442_() {
        return this.baseConfiguration.getTransforms();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        Map overrides = (Map)extraData.get(TEXTURES);
        if (overrides == null) {
            overrides = Collections.EMPTY_MAP;
        }
        boolean noSupplier = true;
        if (renderType != null) {
            for (BlockDefinition supplier : overrides.values()) {
                if (supplier == null) continue;
                noSupplier = false;
                if (!supplier.canRenderInLayer(renderType)) continue;
                BakedModel model = this.getModel(overrides);
                return model.getQuads(state, side, rand, extraData, renderType);
            }
        }
        if (renderType == null || noSupplier && renderType == RenderType.m_110451_()) {
            BakedModel model = this.getModel(overrides);
            return model.getQuads(state, side, rand, extraData, renderType);
        }
        return Collections.EMPTY_LIST;
    }

    public BakedModel getModel(Map<String, BlockDefinition> overrides) {
        String key = RetextureModel.generateKey(overrides);
        try {
            return (BakedModel)this.baked.get((Object)key, () -> {
                ModelConfiguration configuration = new ModelConfiguration((IGeometryBakingContext)this.baseConfiguration, overrides);
                return this.baseConfiguration.getCustomGeometry().bake((IGeometryBakingContext)configuration, this.baker, this.baker.getModelTextureGetter()::apply, this.variant, this.overrideList, this.modelLocation);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }
    }

    private static String generateKey(Map<String, BlockDefinition> overrides) {
        if (overrides == null) {
            return "";
        }
        return StringUtils.join(overrides.entrySet(), (char)',');
    }

    public boolean m_7547_() {
        return this.baseConfiguration.useBlockLight();
    }

    public static int getColor(Map<String, BlockDefinition> textures, BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        BlockDefinition supplier = textures.get(Integer.toString(index));
        if (supplier != null) {
            return supplier.getColor(state, level, pos, index);
        }
        return -1;
    }

    public static class Overrides
    extends ItemOverrides {
        private final RetextureModel baked;
        private final Cache<ItemStack, BakedModel> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(300L, TimeUnit.SECONDS).weakKeys().build();

        public Overrides(RetextureModel model) {
            this.baked = model;
        }

        public BakedModel m_173464_(BakedModel model, ItemStack stack, ClientLevel worldIn, LivingEntity entityIn, int seed) {
            if (model instanceof RetextureModel) {
                try {
                    model = (BakedModel)this.cache.get((Object)stack, () -> this.baked.getModel(Overrides.overridesFromItem(stack)));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return model;
        }

        public static Map<String, BlockDefinition> overridesFromItem(ItemStack stack) {
            CompoundTag data = NBTHelper.of(stack).getTag("BlockEntityTag.Overrides");
            if (data == null) {
                data = new CompoundTag();
            }
            Set keySet = data.m_128431_();
            HashMap overrides = Maps.newHashMapWithExpectedSize((int)keySet.size());
            keySet.forEach(k -> overrides.put(k, null));
            RetextureBlockEntity.readTextures(overrides, data, (Predicate<BlockDefinition>)Predicates.alwaysTrue());
            return overrides;
        }

        public ImmutableList<ItemOverrides.BakedOverride> getOverrides() {
            return ImmutableList.of();
        }
    }

    public static class ModelConfiguration
    implements IGeometryBakingContext {
        private final IGeometryBakingContext baseConfiguration;
        private final Map<String, BlockDefinition> overrides;

        public ModelConfiguration(IGeometryBakingContext baseConfiguration, Map<String, BlockDefinition> overrides) {
            this.baseConfiguration = baseConfiguration;
            this.overrides = overrides;
        }

        public String getModelName() {
            return this.baseConfiguration.getModelName();
        }

        public boolean hasMaterial(String name) {
            return this.baseConfiguration.hasMaterial(name);
        }

        public Material getMaterial(String name) {
            if (name.charAt(0) == '#') {
                String ref0;
                BlockDefinition supplier;
                String ref = name.substring(1);
                int i = ref.lastIndexOf(95);
                if (i != -1 && (supplier = this.overrides.get(ref0 = ref.substring(0, i))) != null) {
                    Direction direction = Direction.m_122402_((String)ref.substring(i + 1));
                    return supplier.renderMaterial(direction);
                }
                BlockDefinition supplier2 = this.overrides.get(ref);
                if (supplier2 != null) {
                    return supplier2.renderMaterial(null);
                }
            }
            return this.baseConfiguration.getMaterial(name);
        }

        public boolean isGui3d() {
            return this.baseConfiguration.isGui3d();
        }

        public boolean useBlockLight() {
            return this.baseConfiguration.useBlockLight();
        }

        public boolean useAmbientOcclusion() {
            return this.baseConfiguration.useAmbientOcclusion();
        }

        public ItemTransforms getTransforms() {
            return this.baseConfiguration.getTransforms();
        }

        public Transformation getRootTransform() {
            return this.baseConfiguration.getRootTransform();
        }

        @Nullable
        public ResourceLocation getRenderTypeHint() {
            return null;
        }

        public boolean isComponentVisible(String component, boolean fallback) {
            return this.baseConfiguration.isComponentVisible(component, fallback);
        }
    }

    public static class Loader
    implements IGeometryLoader<Geometry> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public Geometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            Function<ModelBaker, BlockModel> blockModel = baker -> (BlockModel)baker.m_245361_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"base")));
            return new Geometry(blockModel, GsonHelper.m_13851_((JsonObject)jsonObject, (String)"particle", (String)"0"), GsonHelper.m_13855_((JsonObject)jsonObject, (String)"inventory", (boolean)true));
        }
    }

    public static class Geometry
    implements IUnbakedGeometry<Geometry> {
        private final Function<ModelBaker, BlockModel> blockModel;
        private final String particle;
        private final boolean inventory;

        public Geometry(Function<ModelBaker, BlockModel> blockModel, String particle, boolean inventory) {
            this.blockModel = blockModel;
            this.particle = particle;
            this.inventory = inventory;
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new RetextureModel(baker, modelTransform, modelLocation, this.blockModel.apply((ModelBaker)baker).customData, this.particle, this.inventory);
        }
    }
}

