/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.item.loader.ItemCodecs;
import snownee.kiwi.customization.item.loader.ItemDefinitionProperties;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.customization.item.loader.KItemTemplates;
import snownee.kiwi.util.codec.CustomizationCodecs;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class BuiltInItemTemplate
extends KItemTemplate {
    private final Optional<ResourceLocation> key;
    @Nullable
    private MapCodec<Item> codec;

    public BuiltInItemTemplate(Optional<ItemDefinitionProperties> properties, Optional<ResourceLocation> key) {
        super(properties);
        this.key = key;
    }

    public static Codec<BuiltInItemTemplate> directCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ItemDefinitionProperties.mapCodecField().forGetter(KItemTemplate::properties), (App)CustomizationCodecs.strictOptionalField(ResourceLocation.f_135803_, "codec").forGetter(BuiltInItemTemplate::key)).apply((Applicative)instance, BuiltInItemTemplate::new));
    }

    @Override
    public KItemTemplate.Type<?> type() {
        return KItemTemplates.BUILT_IN.getOrCreate();
    }

    @Override
    public void resolve(ResourceLocation key, OneTimeLoader.Context context) {
        this.codec = ItemCodecs.get(this.key.orElse(key));
    }

    @Override
    public Item createItem(ResourceLocation id, Item.Properties properties, JsonObject json) {
        DataResult result;
        if (!json.has("properties")) {
            json.add("properties", (JsonElement)new JsonObject());
        }
        if ((result = Objects.requireNonNull(this.codec).decode((DynamicOps)JsonOps.INSTANCE, (MapLike)JsonOps.INSTANCE.getMap((JsonElement)json).result().orElseThrow())).error().isPresent()) {
            throw new IllegalStateException(((DataResult.PartialResult)result.error().get()).message());
        }
        return (Item)result.result().orElseThrow();
    }

    public Optional<ResourceLocation> key() {
        return this.key;
    }

    public String toString() {
        return "BuiltInItemTemplate[properties=" + String.valueOf(this.properties) + ", key=" + String.valueOf(this.key) + ", codec=" + String.valueOf(this.codec) + "]";
    }
}

