/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import snownee.kiwi.recipe.AlternativesIngredient;

public class AlternativesIngredientBuilder {
    List<Ingredient> ingredients = Lists.newArrayList();

    public static AlternativesIngredientBuilder of() {
        return new AlternativesIngredientBuilder();
    }

    public AlternativesIngredientBuilder add(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public AlternativesIngredientBuilder add(ItemLike itemLike) {
        this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
        return this;
    }

    public AlternativesIngredientBuilder add(TagKey<Item> tag) {
        this.ingredients.add(Ingredient.m_204132_(tag));
        return this;
    }

    public AlternativesIngredientBuilder add(String tagOrItem) {
        if (tagOrItem.startsWith("#")) {
            this.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagOrItem.substring(1))));
        } else {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(tagOrItem));
            Preconditions.checkState((item != Items.f_41852_ ? 1 : 0) != 0);
            this.add((ItemLike)item);
        }
        return this;
    }

    public AlternativesIngredient build() {
        JsonArray jsonArray = new JsonArray(this.ingredients.size());
        for (Ingredient ingredient : this.ingredients) {
            jsonArray.add(ingredient.m_43942_());
        }
        return new AlternativesIngredient(jsonArray);
    }
}

