/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.api;

import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.service.FatiguePlayerService;
import cn.handyplus.fatigue.util.SendActionBarMsgUtil;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PlayerFatigueApi {
    public static Integer getAmount(UUID playerUuid) {
        return FatiguePlayerService.getInstance().findByPlayerUuid(playerUuid).map(FatiguePlayer::getAmount).orElse(0);
    }

    public static boolean give(UUID playerUuid, Integer amount) {
        return FatiguePlayerService.getInstance().giveAmount(playerUuid, amount);
    }

    public static boolean take(UUID playerUuid, Integer amount) {
        return FatiguePlayerService.getInstance().takeAmount(playerUuid, amount);
    }

    public static boolean set(UUID playerUuid, Integer amount) {
        return FatiguePlayerService.getInstance().setAmount(playerUuid, amount);
    }

    public static Integer getMaxAmount(UUID playerUuid) {
        return FatiguePlayerService.getInstance().findByPlayerUuid(playerUuid).map(FatiguePlayer::getMaxAmount).filter(amount -> amount != 0).orElse(BaseConstants.CONFIG.getInt("maxFatigue"));
    }

    public static boolean giveMaxAmount(UUID playerUuid, Integer maxAmount) {
        return FatiguePlayerService.getInstance().giveMaxAmount(playerUuid, maxAmount);
    }

    public static boolean takeMaxAmount(UUID playerUuid, Integer maxAmount) {
        return FatiguePlayerService.getInstance().takeMaxAmount(playerUuid, maxAmount);
    }

    public static boolean setMaxAmount(UUID playerUuid, Integer maxAmount) {
        return FatiguePlayerService.getInstance().setMaxAmount(playerUuid, maxAmount);
    }

    public static void sendActionBarMsg(Player player) {
        if (!BaseConstants.CONFIG.getBoolean("isActionBar") || player == null) {
            return;
        }
        SendActionBarMsgUtil.sendActionBarMsg(player);
    }
}

