/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.command;

import cn.handyplus.fatigue.constants.TabListEnum;
import cn.handyplus.fatigue.lib.annotation.HandyCommand;
import cn.handyplus.fatigue.lib.command.HandyCommandWrapper;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="playerFatigue")
public class PlayerFatigueCommand
implements TabExecutor {
    private static final String PERMISSION = "playerFatigue.reload";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        boolean rst = HandyCommandWrapper.onCommand(sender, cmd, label, args, BaseUtil.getLangMsg("noPermission"));
        if (!rst) {
            this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission(PERMISSION)) {
            return new ArrayList<String>();
        }
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return;
        }
        List helps = BaseConstants.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, help);
        }
    }
}

