/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.command.admin;

import cn.handyplus.fatigue.api.PlayerFatigueApi;
import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.command.IHandyCommandEvent;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.util.AssertUtil;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.MessageUtil;
import cn.handyplus.fatigue.service.FatiguePlayerService;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class AddMaxCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addMax";
    }

    @Override
    public String permission() {
        return "playerFatigue.addMax";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        int maxFatigue = BaseConstants.CONFIG.getInt("maxFatigue");
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(args[1]);
        Optional<FatiguePlayer> fatiguePlayerOpt = FatiguePlayerService.getInstance().findByPlayerUuid(offlinePlayer.getUniqueId());
        if (!fatiguePlayerOpt.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayer"));
            return;
        }
        FatiguePlayer fatiguePlayer = fatiguePlayerOpt.get();
        int maxAmount = fatiguePlayer.getMaxAmount() == 0 ? maxFatigue + amount : amount;
        boolean rst = PlayerFatigueApi.giveMaxAmount(fatiguePlayer.getPlayerUuid(), maxAmount);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

