/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.command.admin;

import cn.handyplus.fatigue.constants.BlockTypeEnum;
import cn.handyplus.fatigue.entity.FatigueBlock;
import cn.handyplus.fatigue.lib.command.IHandyCommandEvent;
import cn.handyplus.fatigue.lib.util.AssertUtil;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.ItemStackUtil;
import cn.handyplus.fatigue.lib.util.MessageUtil;
import cn.handyplus.fatigue.service.FatigueBlockService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SetBlockCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setBlock";
    }

    @Override
    public String permission() {
        return "playerFatigue.setBlock";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Player player = (Player)sender;
        BlockTypeEnum typeEnum = BlockTypeEnum.getEnum(args[1]);
        AssertUtil.notNull((Object)typeEnum, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        FatigueBlock fatigueBlock = new FatigueBlock();
        ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
        if (Material.AIR.equals((Object)itemInMainHand.getType())) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noAir"));
            return;
        }
        fatigueBlock.setType(typeEnum.getType());
        fatigueBlock.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        fatigueBlock.setAmount(amount);
        boolean rst = FatigueBlockService.getInstance().add(fatigueBlock);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

