/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.command.admin;

import cn.handyplus.fatigue.api.PlayerFatigueApi;
import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.command.IHandyCommandEvent;
import cn.handyplus.fatigue.lib.util.AssertUtil;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.MessageUtil;
import cn.handyplus.fatigue.service.FatiguePlayerService;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class SetMaxCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "setMax";
    }

    @Override
    public String permission() {
        return "playerFatigue.setMax";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer amount = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(args[1]);
        Optional<FatiguePlayer> fatiguePlayerOpt = FatiguePlayerService.getInstance().findByPlayerUuid(offlinePlayer.getUniqueId());
        if (!fatiguePlayerOpt.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayer"));
            return;
        }
        boolean rst = PlayerFatigueApi.setMaxAmount(offlinePlayer.getUniqueId(), amount);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

