/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.command.admin;

import cn.handyplus.fatigue.api.PlayerFatigueApi;
import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.command.IHandyCommandEvent;
import cn.handyplus.fatigue.lib.util.AssertUtil;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.MessageUtil;
import cn.handyplus.fatigue.service.FatiguePlayerService;
import java.util.Optional;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TakeCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "take";
    }

    @Override
    public String permission() {
        return "playerFatigue.take";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getLangMsg("paramFailureMsg"));
        int number = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getLangMsg("amountFailureMsg"));
        OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(args[1]);
        Optional<FatiguePlayer> fatiguePlayerOpt = FatiguePlayerService.getInstance().findByPlayerUuid(offlinePlayer.getUniqueId());
        if (!fatiguePlayerOpt.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayer"));
            return;
        }
        FatiguePlayer fatiguePlayer = fatiguePlayerOpt.get();
        boolean rst = number >= fatiguePlayer.getAmount() ? PlayerFatigueApi.set(offlinePlayer.getUniqueId(), 0) : PlayerFatigueApi.take(offlinePlayer.getUniqueId(), number);
        MessageUtil.sendMessage(sender, BaseUtil.getLangMsg(rst ? "succeedMsg" : "failureMsg"));
    }
}

