/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.inventory;

import cn.handyplus.fatigue.constants.BlockTypeEnum;
import cn.handyplus.fatigue.constants.GuiTypeEnum;
import cn.handyplus.fatigue.entity.FatigueBlock;
import cn.handyplus.fatigue.hook.PlaceholderApiUtil;
import cn.handyplus.fatigue.lib.core.MapUtil;
import cn.handyplus.fatigue.lib.core.StrUtil;
import cn.handyplus.fatigue.lib.db.Page;
import cn.handyplus.fatigue.lib.inventory.HandyInventory;
import cn.handyplus.fatigue.lib.inventory.HandyInventoryUtil;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.ItemStackUtil;
import cn.handyplus.fatigue.service.FatigueBlockService;
import cn.handyplus.fatigue.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BlockGui {
    private static final BlockGui INSTANCE = new BlockGui();

    private BlockGui() {
    }

    public static BlockGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.VIEW_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.VIEW_CONFIG.getInt("size", 54);
        String sound = ConfigUtil.VIEW_CONFIG.getString("sound");
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.BLOCK.getType(), title, size, sound);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.BLOCK.getType());
        handyInventory.setSearchType(handyInventory.getSearchType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
        this.setDate(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Map<Integer, String> soundMap = handyInventory.getSoundMap();
        Inventory inv = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        String indexListStr = ConfigUtil.VIEW_CONFIG.getString("block.index");
        List<Integer> indexList = StrUtil.strToIntList(indexListStr);
        handyInventory.setPageSize(indexList.size());
        Page<FatigueBlock> page = FatigueBlockService.getInstance().findPage(handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        int i = 0;
        String sound = ConfigUtil.VIEW_CONFIG.getString("block.sound");
        for (FatigueBlock fatigueBlock : page.getRecords()) {
            List loreList = ConfigUtil.VIEW_CONFIG.getStringList("block.lore");
            Map<String, String> fatigueBlockMap = this.getFatigueBlockMap(fatigueBlock);
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(fatigueBlock.getItemStack());
            Integer index = indexList.get(i++);
            inv.setItem(index.intValue(), ItemStackUtil.getItemStack(itemStack.getType().name(), BaseUtil.getDisplayName(itemStack), loreList, false, 0, true, fatigueBlockMap));
            map.put(index, fatigueBlock.getId());
            soundMap.put(index, sound);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, handyInventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, handyInventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setCustomButton(ConfigUtil.VIEW_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> getFatigueBlockMap(FatigueBlock fatigueBlock) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("amount", fatigueBlock.getAmount().toString());
        map.put("type", BlockTypeEnum.getEnum(fatigueBlock.getType()) != null ? BlockTypeEnum.getName(fatigueBlock.getType()) : fatigueBlock.getType());
        return map;
    }
}

