/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.lib;

import cn.handyplus.fatigue.lib.annotation.TableName;
import cn.handyplus.fatigue.lib.command.HandyCommandWrapper;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.constants.VersionCheckEnum;
import cn.handyplus.fatigue.lib.core.ClassUtil;
import cn.handyplus.fatigue.lib.core.CollUtil;
import cn.handyplus.fatigue.lib.db.Db;
import cn.handyplus.fatigue.lib.db.SqlManagerUtil;
import cn.handyplus.fatigue.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.fatigue.lib.inventory.HandyInventoryUtil;
import cn.handyplus.fatigue.lib.inventory.HandyInventoryWrapper;
import cn.handyplus.fatigue.lib.inventory.InventoryViewUtil;
import cn.handyplus.fatigue.lib.metrics.Metrics;
import cn.handyplus.fatigue.lib.util.BcUtil;
import cn.handyplus.fatigue.lib.util.HandyHttpUtil;
import cn.handyplus.fatigue.lib.util.LegacyUtil;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InitApi {
    private static final InitApi INSTANCE = new InitApi();
    public static JavaPlugin PLUGIN;
    private static ClassUtil CLASS_UTIL;

    private InitApi() {
    }

    public static InitApi getInstance(JavaPlugin plugin) {
        PLUGIN = plugin;
        BaseConstants.VERSION_CHECK_ENUM = VersionCheckEnum.getEnum();
        BaseConstants.VERSION_ID = BaseConstants.VERSION_CHECK_ENUM.getVersionId();
        CLASS_UTIL = new ClassUtil();
        HandySchedulerUtil.init((Plugin)plugin);
        LegacyUtil.initClasses();
        InventoryViewUtil.init(BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_21.getVersionId());
        return INSTANCE;
    }

    public InitApi initCommand(String packageName) {
        HandyCommandWrapper.initCommand(packageName);
        return this;
    }

    public InitApi initListener(String packageName) {
        return this.initListener(packageName, null);
    }

    public InitApi initListener(String packageName, List<String> ignoreList) {
        HandyInventoryWrapper.initListener(packageName, ignoreList);
        return this;
    }

    public InitApi initClickEvent(String packageName) {
        HandyInventoryWrapper.initClickEvent(packageName);
        return this;
    }

    public InitApi checkVersion() {
        if (BaseConstants.IS_CHECK_UPDATE) {
            HandyHttpUtil.checkVersion(null);
        }
        return this;
    }

    public InitApi addMetrics(int pluginId) {
        return this.addMetrics(pluginId, null);
    }

    public InitApi addMetrics(int pluginId, List<Metrics.CustomChart> customCharts) {
        try {
            Metrics metrics = new Metrics(PLUGIN, pluginId);
            if (CollUtil.isNotEmpty(customCharts)) {
                for (Metrics.CustomChart customChart : customCharts) {
                    metrics.addCustomChart(customChart);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public InitApi enableSql(String packageName) {
        List<Class<?>> tableList = CLASS_UTIL.getClassByAnnotation(packageName, TableName.class);
        if (CollUtil.isEmpty(tableList)) {
            return this;
        }
        SqlManagerUtil.getInstance().enableSql();
        for (Class<?> aClass : tableList) {
            if (!aClass.getAnnotation(TableName.class).create()) continue;
            Db.use(aClass).createTable();
        }
        return this;
    }

    public InitApi enableBc() {
        BcUtil.registerOut();
        return this;
    }

    public static void disable() {
        HandyInventoryUtil.closeHandyInventory();
        SqlManagerUtil.getInstance().close();
        HandySchedulerUtil.cancelTask();
    }
}

