/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.lib.util;

import cn.handyplus.fatigue.lib.core.CollUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LotteryUtil {
    private final List<ContinuousList> lotteryList = new ArrayList<ContinuousList>();
    private double maxElement;

    public LotteryUtil(List<Double> list) {
        if (CollUtil.isNotEmpty(list)) {
            for (Double d : list) {
                double minElement = this.maxElement;
                this.maxElement += d.doubleValue();
                ContinuousList continuousList = new ContinuousList(minElement, this.maxElement);
                this.lotteryList.add(continuousList);
            }
        } else {
            throw new IllegalArgumentException("\u62bd\u5956\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public int randomIndex() {
        int index = -1;
        Random r = new Random();
        double d = r.nextDouble() * this.maxElement;
        if (d == 0.0) {
            d = r.nextDouble() * this.maxElement;
        }
        int size = this.lotteryList.size();
        for (int i = 0; i < size; ++i) {
            ContinuousList cl = this.lotteryList.get(i);
            if (!cl.isContainKey(d)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("\u6982\u7387\u96c6\u5408\u8bbe\u7f6e\u4e0d\u5408\u7406\uff01");
        }
        return index;
    }

    private static class ContinuousList {
        private final double minElement;
        private final double maxElement;

        public ContinuousList(double minElement, double maxElement) {
            if (minElement > maxElement) {
                throw new IllegalArgumentException("\u533a\u95f4\u4e0d\u5408\u7406\uff0cminElement\u4e0d\u80fd\u5927\u4e8emaxElement\uff01");
            }
            this.minElement = minElement;
            this.maxElement = maxElement;
        }

        public boolean isContainKey(double element) {
            return element > this.minElement && element <= this.maxElement;
        }
    }
}

