/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.listener;

import cn.handyplus.fatigue.api.PlayerFatigueApi;
import cn.handyplus.fatigue.constants.BlockTypeEnum;
import cn.handyplus.fatigue.constants.FatigueConstants;
import cn.handyplus.fatigue.entity.FatigueBlock;
import cn.handyplus.fatigue.lib.annotation.HandyListener;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.ItemStackUtil;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class BlockBreakEventListener
implements Listener {
    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Material material = event.getBlock().getType();
        Player player = event.getPlayer();
        List worlds = BaseConstants.CONFIG.getStringList("worlds");
        if (!worlds.contains(player.getWorld().getName())) {
            return;
        }
        int rstCount = 0;
        for (FatigueBlock fatigueBlock : FatigueConstants.FATIGUE_BLOCK_LIST) {
            ItemStack itemStack;
            if (fatigueBlock.getType() != null && !BlockTypeEnum.BLOCK_BREAK.getType().equals(fatigueBlock.getType()) || (itemStack = ItemStackUtil.itemStackDeserialize(fatigueBlock.getItemStack())) == null || !material.equals((Object)itemStack.getType())) continue;
            boolean rst = PlayerFatigueApi.take(player.getUniqueId(), fatigueBlock.getAmount());
            if (!rst) {
                event.setCancelled(true);
                player.sendMessage(BaseUtil.getLangMsg("notFatigue"));
                continue;
            }
            ++rstCount;
        }
        if (rstCount > 0) {
            PlayerFatigueApi.sendActionBarMsg(player);
        }
    }
}

