/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.listener;

import cn.handyplus.fatigue.api.PlayerFatigueApi;
import cn.handyplus.fatigue.constants.BlockTypeEnum;
import cn.handyplus.fatigue.constants.FatigueConstants;
import cn.handyplus.fatigue.entity.FatigueBlock;
import cn.handyplus.fatigue.lib.annotation.HandyListener;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.ItemStackUtil;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class CraftItemEventListener
implements Listener {
    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack eventItemStack = event.getInventory().getResult();
        if (eventItemStack == null) {
            return;
        }
        HumanEntity whoClicked = event.getWhoClicked();
        if (!(whoClicked instanceof Player)) {
            return;
        }
        Player player = (Player)whoClicked;
        List worlds = BaseConstants.CONFIG.getStringList("worlds");
        if (!worlds.contains(player.getWorld().getName())) {
            return;
        }
        int rstCount = 0;
        for (FatigueBlock fatigueBlock : FatigueConstants.FATIGUE_BLOCK_LIST) {
            ItemStack itemStack;
            if (!BlockTypeEnum.BLOCK_CRAFT_ITEM.getType().equals(fatigueBlock.getType()) || (itemStack = ItemStackUtil.itemStackDeserialize(fatigueBlock.getItemStack())) == null || !eventItemStack.isSimilar(itemStack)) continue;
            boolean rst = PlayerFatigueApi.take(player.getUniqueId(), fatigueBlock.getAmount());
            if (!rst) {
                event.setCancelled(true);
                player.sendMessage(BaseUtil.getLangMsg("notFatigue"));
                continue;
            }
            ++rstCount;
        }
        if (rstCount > 0) {
            PlayerFatigueApi.sendActionBarMsg(player);
        }
    }
}

