/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.listener;

import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.annotation.HandyListener;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.fatigue.lib.util.HandyHttpUtil;
import cn.handyplus.fatigue.service.FatiguePlayerService;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@HandyListener
public class PlayerJoinEventListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            FatiguePlayerService.getInstance().setPlayerName(player);
            Optional<FatiguePlayer> fatiguePlayerOpt = FatiguePlayerService.getInstance().findByPlayerUuid(player.getUniqueId());
            if (fatiguePlayerOpt.isPresent()) {
                return;
            }
            FatiguePlayer fatiguePlayer = new FatiguePlayer();
            fatiguePlayer.setPlayerName(player.getName());
            fatiguePlayer.setPlayerUuid(player.getUniqueId());
            fatiguePlayer.setAmount(BaseConstants.CONFIG.getInt("maxFatigue"));
            fatiguePlayer.setMaxAmount(0);
            FatiguePlayerService.getInstance().add(fatiguePlayer);
        });
    }

    @EventHandler
    public void onOpPlayerJoin(PlayerJoinEvent event) {
        HandyHttpUtil.checkVersion(event.getPlayer());
    }
}

