/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.listener.gui;

import cn.handyplus.fatigue.constants.GuiTypeEnum;
import cn.handyplus.fatigue.inventory.BlockGui;
import cn.handyplus.fatigue.lib.core.StrUtil;
import cn.handyplus.fatigue.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.fatigue.lib.inventory.HandyInventory;
import cn.handyplus.fatigue.lib.inventory.HandyInventoryUtil;
import cn.handyplus.fatigue.lib.inventory.IHandyClickEvent;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.MessageUtil;
import cn.handyplus.fatigue.service.FatigueBlockService;
import cn.handyplus.fatigue.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class BlockClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.BLOCK.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Player player = handyInventory.getPlayer();
        if (rawSlot == HandyInventoryUtil.getIndex(ConfigUtil.VIEW_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                BlockGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (rawSlot == HandyInventoryUtil.getIndex(ConfigUtil.VIEW_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                BlockGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.VIEW_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            PlayerSchedulerUtil.syncPerformReplaceCommand(player, command);
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.VIEW_CONFIG.getString("block.index"));
        if (indexList.contains(rawSlot) && map.get(rawSlot) != null) {
            Integer id = map.get(event.getRawSlot());
            boolean rst = FatigueBlockService.getInstance().deleteById(id);
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
            BlockGui.getInstance().setInventoryDate(handyInventory);
        }
    }
}

